/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.connector.sink.CompactorSink;
import org.apache.flink.table.store.connector.sink.OffsetRowDataHashStreamPartitioner;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.system.BucketsTable;

public class CompactorSinkBuilder {
    private final FileStoreTable table;
    private DataStream<RowData> input;
    private Lock.Factory lockFactory = Lock.emptyFactory();

    public CompactorSinkBuilder(FileStoreTable table) {
        this.table = table;
    }

    public CompactorSinkBuilder withInput(DataStream<RowData> input) {
        this.input = input;
        return this;
    }

    public CompactorSinkBuilder withLockFactory(Lock.Factory lockFactory) {
        this.lockFactory = lockFactory;
        return this;
    }

    public DataStreamSink<?> build() {
        OffsetRowDataHashStreamPartitioner partitioner = new OffsetRowDataHashStreamPartitioner(BucketsTable.partitionWithBucketRowType(this.table.schema().logicalPartitionType()), 1);
        PartitionTransformation partitioned = new PartitionTransformation(this.input.getTransformation(), (StreamPartitioner)partitioner);
        StreamExecutionEnvironment env = this.input.getExecutionEnvironment();
        CompactorSink sink = new CompactorSink(this.table, this.lockFactory);
        return sink.sinkFrom((DataStream<RowData>)new DataStream(env, (Transformation)partitioned));
    }
}

