/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.io.airlift.compress.snappy;

import java.nio.ByteBuffer;
import org.apache.flink.table.store.shaded.io.airlift.compress.Compressor;
import org.apache.flink.table.store.shaded.io.airlift.compress.snappy.SnappyRawCompressor;
import org.apache.flink.table.store.shaded.io.airlift.compress.snappy.UnsafeUtil;
import sun.misc.Unsafe;

public class SnappyCompressor
implements Compressor {
    private final short[] table = new short[16384];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return SnappyRawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawCompressor.compress(input, inputAddress, inputLimit, output, outputAddress, outputLimit, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress(ByteBuffer input, ByteBuffer output) {
        long outputLimit;
        long outputAddress;
        byte[] outputBase;
        long inputLimit;
        long inputAddress;
        byte[] inputBase;
        if (input.isDirect()) {
            inputBase = null;
            long address = UnsafeUtil.getAddress(input);
            inputAddress = address + (long)input.position();
            inputLimit = address + (long)input.limit();
        } else if (input.hasArray()) {
            inputBase = input.array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (output.isDirect()) {
            outputBase = null;
            long address = UnsafeUtil.getAddress(output);
            outputAddress = address + (long)output.position();
            outputLimit = address + (long)output.limit();
        } else if (output.hasArray()) {
            outputBase = output.array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = SnappyRawCompressor.compress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit, this.table);
                output.position(output.position() + written);
            }
        }
    }
}

