/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.file.CodecFactory;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.file.DataFileWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericDatumWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.util.Preconditions;

public class AvroOutputFormat<E>
extends FileOutputFormat<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<E> avroValueType;
    private transient Schema userDefinedSchema = null;
    private transient Codec codec = null;
    private transient DataFileWriter<E> dataFileWriter;

    public AvroOutputFormat(Path filePath, Class<E> type) {
        super(filePath);
        this.avroValueType = type;
    }

    public AvroOutputFormat(Class<E> type) {
        this.avroValueType = type;
    }

    protected String getDirectoryFileName(int taskNumber) {
        return super.getDirectoryFileName(taskNumber) + ".avro";
    }

    public void setSchema(Schema schema) {
        this.userDefinedSchema = schema;
    }

    public void setCodec(Codec codec) {
        this.codec = (Codec)((Object)Preconditions.checkNotNull((Object)((Object)codec), (String)"codec can not be null"));
    }

    public void writeRecord(E record) throws IOException {
        this.dataFileWriter.append(record);
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        Schema schema;
        GenericDatumWriter datumWriter;
        super.open(taskNumber, numTasks);
        if (SpecificRecordBase.class.isAssignableFrom(this.avroValueType)) {
            datumWriter = new SpecificDatumWriter<E>(this.avroValueType);
            try {
                schema = ((SpecificRecordBase)this.avroValueType.newInstance()).getSchema();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else if (GenericRecord.class.isAssignableFrom(this.avroValueType)) {
            if (this.userDefinedSchema == null) {
                throw new IllegalStateException("Schema must be set when using Generic Record");
            }
            datumWriter = new GenericDatumWriter(this.userDefinedSchema);
            schema = this.userDefinedSchema;
        } else {
            datumWriter = new ReflectDatumWriter<E>(this.avroValueType);
            schema = ReflectData.get().getSchema(this.avroValueType);
        }
        this.dataFileWriter = new DataFileWriter<E>(datumWriter);
        if (this.codec != null) {
            this.dataFileWriter.setCodec(this.codec.getCodecFactory());
        }
        if (this.userDefinedSchema == null) {
            this.dataFileWriter.create(schema, (OutputStream)this.stream);
        } else {
            this.dataFileWriter.create(this.userDefinedSchema, (OutputStream)this.stream);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.codec != null) {
            out.writeByte(this.codec.getCodecByte());
        } else {
            out.writeByte(-1);
        }
        if (this.userDefinedSchema != null) {
            byte[] json = this.userDefinedSchema.toString().getBytes(ConfigConstants.DEFAULT_CHARSET);
            out.writeInt(json.length);
            out.write(json);
        } else {
            out.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int length;
        in.defaultReadObject();
        byte codecByte = in.readByte();
        if (codecByte >= 0) {
            this.setCodec(Codec.forCodecByte(codecByte));
        }
        if ((length = in.readInt()) != 0) {
            byte[] json = new byte[length];
            in.readFully(json);
            Schema schema = new Schema.Parser().parse(new String(json, ConfigConstants.DEFAULT_CHARSET));
            this.setSchema(schema);
        }
    }

    public void close() throws IOException {
        this.dataFileWriter.flush();
        this.dataFileWriter.close();
        super.close();
    }

    public static enum Codec {
        NULL(0, CodecFactory.nullCodec()),
        SNAPPY(1, CodecFactory.snappyCodec()),
        BZIP2(2, CodecFactory.bzip2Codec()),
        DEFLATE(3, CodecFactory.deflateCodec(-1)),
        XZ(4, CodecFactory.xzCodec(6));

        private byte codecByte;
        private CodecFactory codecFactory;

        private Codec(byte codecByte, CodecFactory codecFactory) {
            this.codecByte = codecByte;
            this.codecFactory = codecFactory;
        }

        private byte getCodecByte() {
            return this.codecByte;
        }

        private CodecFactory getCodecFactory() {
            return this.codecFactory;
        }

        private static Codec forCodecByte(byte codecByte) {
            for (Codec codec : Codec.values()) {
                if (codec.getCodecByte() != codecByte) continue;
                return codec;
            }
            throw new IllegalArgumentException("no codec for codecByte: " + codecByte);
        }
    }
}

