/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;

public class RecordMapperWrapperRecordIterator<I, O>
implements BulkFormat.RecordIterator<O> {
    private final BulkFormat.RecordIterator<I> wrapped;
    private final RecordMapper<I, O> mapper;

    public RecordMapperWrapperRecordIterator(BulkFormat.RecordIterator<I> wrapped, RecordMapper<I, O> mapper) {
        this.wrapped = wrapped;
        this.mapper = mapper;
    }

    @Override
    public RecordAndPosition<O> next() {
        RecordAndPosition<I> record = this.wrapped.next();
        if (record == null || record.getRecord() == null) {
            return record;
        }
        record.record = this.mapper.map(record.record);
        return record;
    }

    @Override
    public void releaseBatch() {
        this.wrapped.releaseBatch();
    }

    public static <I, O> BulkFormat.Reader<O> wrapReader(final BulkFormat.Reader<I> wrappedReader, final RecordMapper<I, O> recordMapper) {
        return new BulkFormat.Reader<O>(){

            @Override
            @Nullable
            public BulkFormat.RecordIterator<O> readBatch() throws IOException {
                BulkFormat.RecordIterator iterator = wrappedReader.readBatch();
                if (iterator == null) {
                    return null;
                }
                return new RecordMapperWrapperRecordIterator(iterator, recordMapper);
            }

            @Override
            public void close() throws IOException {
                wrappedReader.close();
            }
        };
    }

    @FunctionalInterface
    public static interface RecordMapper<I, O> {
        public O map(I var1);
    }
}

