/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchArgumentToPredicateConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SearchArgumentToPredicateConverter.class);
    private final ExpressionTree root;
    private final List<PredicateLeaf> leaves;
    private final List<String> columnNames;
    private final List<LogicalType> columnTypes;
    private final PredicateBuilder builder;

    public SearchArgumentToPredicateConverter(SearchArgument sarg, List<String> columnNames, List<LogicalType> columnTypes) {
        this.root = sarg.getExpression();
        this.leaves = sarg.getLeaves();
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.builder = new PredicateBuilder(RowType.of(columnTypes.toArray(new LogicalType[0]), columnNames.toArray(new String[0])));
    }

    public Optional<Predicate> convert() {
        ArrayList<ExpressionTree> trees = new ArrayList<ExpressionTree>();
        if (this.root.getOperator() == ExpressionTree.Operator.AND) {
            trees.addAll(this.root.getChildren());
        } else {
            trees.add(this.root);
        }
        ArrayList<Predicate> converted = new ArrayList<Predicate>();
        for (ExpressionTree tree : trees) {
            try {
                converted.add(this.convertTree(tree));
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Failed to convert predicate " + tree + "  due to unsupported feature. This part of filter will be processed by Hive instead.", (Throwable)e);
            }
        }
        return converted.isEmpty() ? Optional.empty() : Optional.of(PredicateBuilder.and(converted));
    }

    private Predicate convertTree(ExpressionTree tree) {
        List children = tree.getChildren();
        switch (tree.getOperator()) {
            case OR: {
                return PredicateBuilder.or(children.stream().map(this::convertTree).collect(Collectors.toList()));
            }
            case AND: {
                return PredicateBuilder.and(children.stream().map(this::convertTree).collect(Collectors.toList()));
            }
            case NOT: {
                return this.convertTree((ExpressionTree)children.get(0)).negate().orElseThrow(() -> new UnsupportedOperationException("Unsupported negate of " + ((ExpressionTree)children.get(0)).getOperator().name()));
            }
            case LEAF: {
                return this.convertLeaf(this.leaves.get(tree.getLeaf()));
            }
        }
        throw new UnsupportedOperationException("Unsupported operator " + tree.getOperator().name());
    }

    private Predicate convertLeaf(PredicateLeaf leaf) {
        String columnName = leaf.getColumnName();
        int idx = this.columnNames.indexOf(columnName);
        Preconditions.checkArgument(idx >= 0, "Column " + columnName + " not found.");
        LogicalType columnType = this.columnTypes.get(idx);
        switch (leaf.getOperator()) {
            case EQUALS: {
                return this.builder.equal(idx, this.toLiteral(columnType, leaf.getLiteral()));
            }
            case LESS_THAN: {
                return this.builder.lessThan(idx, this.toLiteral(columnType, leaf.getLiteral()));
            }
            case LESS_THAN_EQUALS: {
                return this.builder.lessOrEqual(idx, this.toLiteral(columnType, leaf.getLiteral()));
            }
            case IN: {
                return this.builder.in(idx, leaf.getLiteralList().stream().map(o -> this.toLiteral(columnType, o)).collect(Collectors.toList()));
            }
            case BETWEEN: {
                List literalList = leaf.getLiteralList();
                return this.builder.between(idx, this.toLiteral(columnType, literalList.get(0)), this.toLiteral(columnType, literalList.get(1)));
            }
            case IS_NULL: {
                return this.builder.isNull(idx);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator " + leaf.getOperator());
    }

    private Object toLiteral(LogicalType literalType, Object o) {
        if (o instanceof HiveDecimalWritable) {
            o = ((HiveDecimalWritable)o).getHiveDecimal().bigDecimalValue();
        }
        return PredicateBuilder.convertJavaObject(literalType, o);
    }
}

