/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class TaskInputsOutputsDescriptor {
    private final int inputGateNums;
    private final Map<IntermediateDataSetID, Integer> inputChannelNums;
    private final Map<IntermediateDataSetID, Integer> subpartitionNums;
    private final Map<IntermediateDataSetID, ResultPartitionType> partitionTypes;

    private TaskInputsOutputsDescriptor(int inputGateNums, Map<IntermediateDataSetID, Integer> inputChannelNums, Map<IntermediateDataSetID, Integer> subpartitionNums, Map<IntermediateDataSetID, ResultPartitionType> partitionTypes) {
        Preconditions.checkNotNull(inputChannelNums);
        Preconditions.checkNotNull(subpartitionNums);
        Preconditions.checkNotNull(partitionTypes);
        this.inputGateNums = inputGateNums;
        this.inputChannelNums = inputChannelNums;
        this.subpartitionNums = subpartitionNums;
        this.partitionTypes = partitionTypes;
    }

    public int getInputGateNums() {
        return this.inputGateNums;
    }

    public Map<IntermediateDataSetID, Integer> getInputChannelNums() {
        return Collections.unmodifiableMap(this.inputChannelNums);
    }

    public Map<IntermediateDataSetID, Integer> getSubpartitionNums() {
        return Collections.unmodifiableMap(this.subpartitionNums);
    }

    public Map<IntermediateDataSetID, ResultPartitionType> getPartitionTypes() {
        return Collections.unmodifiableMap(this.partitionTypes);
    }

    public static TaskInputsOutputsDescriptor from(int inputGateNums, Map<IntermediateDataSetID, Integer> inputChannelNums, Map<IntermediateDataSetID, Integer> subpartitionNums, Map<IntermediateDataSetID, ResultPartitionType> partitionTypes) {
        return new TaskInputsOutputsDescriptor(inputGateNums, inputChannelNums, subpartitionNums, partitionTypes);
    }
}

