/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;

public class IOMetrics
implements Serializable {
    private static final long serialVersionUID = -7208093607556457183L;
    protected long numRecordsIn;
    protected long numRecordsOut;
    protected long numBytesIn;
    protected long numBytesOut;
    protected long accumulateBackPressuredTime;
    protected double accumulateBusyTime;
    protected long accumulateIdleTime;
    protected final Map<IntermediateResultPartitionID, Long> numBytesProducedOfPartitions = new HashMap<IntermediateResultPartitionID, Long>();

    public IOMetrics(Meter recordsIn, Meter recordsOut, Meter bytesIn, Meter bytesOut, Map<IntermediateResultPartitionID, Counter> numBytesProducedCounters, Gauge<Long> accumulatedBackPressuredTime, Gauge<Long> accumulatedIdleTime, Gauge<Double> accumulatedBusyTime) {
        this.numRecordsIn = recordsIn.getCount();
        this.numRecordsOut = recordsOut.getCount();
        this.numBytesIn = bytesIn.getCount();
        this.numBytesOut = bytesOut.getCount();
        this.accumulateBackPressuredTime = (Long)accumulatedBackPressuredTime.getValue();
        this.accumulateBusyTime = (Double)accumulatedBusyTime.getValue();
        this.accumulateIdleTime = (Long)accumulatedIdleTime.getValue();
        for (Map.Entry<IntermediateResultPartitionID, Counter> counter : numBytesProducedCounters.entrySet()) {
            this.numBytesProducedOfPartitions.put(counter.getKey(), counter.getValue().getCount());
        }
    }

    public IOMetrics(long numBytesIn, long numBytesOut, long numRecordsIn, long numRecordsOut, long accumulateIdleTime, long accumulateBusyTime, long accumulateBackPressuredTime) {
        this.numBytesIn = numBytesIn;
        this.numBytesOut = numBytesOut;
        this.numRecordsIn = numRecordsIn;
        this.numRecordsOut = numRecordsOut;
        this.accumulateIdleTime = accumulateIdleTime;
        this.accumulateBusyTime = accumulateBusyTime;
        this.accumulateBackPressuredTime = accumulateBackPressuredTime;
    }

    public long getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public long getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public long getNumBytesIn() {
        return this.numBytesIn;
    }

    public long getNumBytesOut() {
        return this.numBytesOut;
    }

    public double getAccumulateBusyTime() {
        return this.accumulateBusyTime;
    }

    public long getAccumulateBackPressuredTime() {
        return this.accumulateBackPressuredTime;
    }

    public long getAccumulateIdleTime() {
        return this.accumulateIdleTime;
    }

    public Map<IntermediateResultPartitionID, Long> getNumBytesProducedOfPartitions() {
        return this.numBytesProducedOfPartitions;
    }
}

