/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;

public class CompressedHeaderlessChannelReaderInputView
extends AbstractChannelReaderInputView
implements RequestDoneCallback<Buffer>,
BufferRecycler {
    private final BlockDecompressor decompressor;
    private final BufferFileReader reader;
    private final MemorySegment uncompressedBuffer;
    private final AtomicReference<IOException> cause;
    private final LinkedBlockingQueue<Buffer> retBuffers = new LinkedBlockingQueue();
    private int numBlocksRemaining;
    private int currentSegmentLimit;

    public CompressedHeaderlessChannelReaderInputView(FileIOChannel.ID id, IOManager ioManager, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize, int numBlocks) throws IOException {
        super(0);
        this.numBlocksRemaining = numBlocks;
        this.reader = ioManager.createBufferFileReader(id, this);
        this.uncompressedBuffer = MemorySegmentFactory.wrap(new byte[compressionBlockSize]);
        this.decompressor = compressionCodecFactory.getDecompressor();
        this.cause = new AtomicReference();
        BlockCompressor compressor = compressionCodecFactory.getCompressor();
        for (int i = 0; i < 2; ++i) {
            MemorySegment segment = MemorySegmentFactory.wrap(new byte[compressor.getMaxCompressedSize(compressionBlockSize)]);
            this.reader.readInto(new NetworkBuffer(segment, this));
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.cause.get() != null) {
            throw this.cause.get();
        }
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        try {
            Buffer buffer;
            while ((buffer = this.retBuffers.poll(1L, TimeUnit.SECONDS)) == null) {
                if (this.cause.get() == null) continue;
                throw this.cause.get();
            }
            this.currentSegmentLimit = this.decompressor.decompress(buffer.getMemorySegment().getArray(), 0, buffer.getSize(), this.uncompressedBuffer.getArray(), 0);
            buffer.recycleBuffer();
            --this.numBlocksRemaining;
            return this.uncompressedBuffer;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public BufferFileReader getReader() {
        return this.reader;
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.currentSegmentLimit;
    }

    @Override
    public List<MemorySegment> close() throws IOException {
        this.reader.close();
        return Collections.emptyList();
    }

    @Override
    public FileIOChannel getChannel() {
        return this.reader;
    }

    public boolean isClosed() {
        return this.reader.isClosed();
    }

    @Override
    public void requestSuccessful(Buffer request) {
        this.retBuffers.add(request);
    }

    @Override
    public void requestFailed(Buffer buffer, IOException e) {
        this.cause.compareAndSet(null, e);
        throw new RuntimeException(e);
    }

    @Override
    public void recycle(MemorySegment segment) {
        try {
            this.reader.readInto(new NetworkBuffer(segment, this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

