/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CacheServerLoadMessage
extends SerialDistributionMessage {
    protected ServerLoad load;
    protected ServerLocation location;
    protected ArrayList clientIds;

    public CacheServerLoadMessage() {
    }

    public CacheServerLoadMessage(ServerLoad load, ServerLocation location, ArrayList clientIds) {
        this.load = load;
        this.location = location;
        this.clientIds = clientIds;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        this.updateLocalLocators();
    }

    public void updateLocalLocators() {
        List<Locator> locators = Locator.getLocators();
        for (int i = 0; i < locators.size(); ++i) {
            InternalLocator l = (InternalLocator)locators.get(i);
            ServerLocator serverLocator = l.getServerLocatorAdvisee();
            if (serverLocator == null) continue;
            serverLocator.updateLoad(this.location, this.load, this.clientIds);
        }
    }

    public int getDSFID() {
        return 24;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.load = new ServerLoad();
        InternalDataSerializer.invokeFromData(this.load, in);
        this.location = new ServerLocation();
        InternalDataSerializer.invokeFromData(this.location, in);
        this.clientIds = DataSerializer.readArrayList(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        InternalDataSerializer.invokeToData(this.load, out);
        InternalDataSerializer.invokeToData(this.location, out);
        DataSerializer.writeArrayList(this.clientIds, out);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

