/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;

public class DurableClientAttributes {
    private final String poolSeparator = "_gem_";
    private String id;
    private int timeout;
    private String poolName;

    public DurableClientAttributes() {
    }

    public DurableClientAttributes(String id, int timeout) {
        this.id = id;
        this.timeout = timeout;
        this.poolName = null;
        int pIdx = id.indexOf("_gem_");
        if (pIdx != -1) {
            this.poolName = id.substring(pIdx + "_gem_".length());
            this.id = id.substring(0, pIdx);
        }
    }

    public String getId() {
        if (this.id == null || this.id.isEmpty()) {
            return this.id;
        }
        String pn = ClientProxyMembershipID.getPoolName();
        if (pn != null) {
            this.poolName = pn;
        }
        String result = this.id;
        if (this.poolName != null) {
            result = result + "_gem_" + this.poolName;
        }
        return result;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void updateTimeout(int newValue) {
        this.timeout = newValue;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DurableClientAttributes)) {
            return false;
        }
        DurableClientAttributes that = (DurableClientAttributes)other;
        if (this.timeout != that.getTimeout()) {
            return false;
        }
        return this.id != null && this.id.equals(that.id) && (this.poolName == null && that.poolName == null || this.poolName != null && this.poolName.equals(that.poolName));
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.timeout;
        result = 37 * result + (this.id == null ? 0 : this.getId().hashCode());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(50).append("DurableClientAttributes[id=").append(this.getId()).append("; timeout=").append(this.timeout).append("]");
        return buffer.toString();
    }
}

