/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.GrantorInfo;
import org.apache.geode.distributed.internal.locks.GrantorRequestProcessor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ElderInitProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private final HashMap grantors;
    private final HashSet crashedGrantors;

    static void init(DistributionManager dm, HashMap<String, GrantorInfo> map) {
        HashSet<String> crashedGrantors = new HashSet<String>();
        Set<InternalDistributedMember> others = dm.getOtherDistributionManagerIds();
        if (!others.isEmpty()) {
            ElderInitProcessor processor = new ElderInitProcessor(dm, others, map, crashedGrantors);
            ElderInitMessage.send(others, dm, processor);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleCause();
            }
        }
        GrantorRequestProcessor.readyForElderRecovery(dm.getSystem(), null, null);
        DLockService.recoverLocalElder(dm, map, crashedGrantors);
        for (String crashedGrantor : crashedGrantors) {
            map.put(crashedGrantor, new GrantorInfo(null, 0L, 0, true));
        }
    }

    private ElderInitProcessor(DistributionManager dm, Set others, HashMap grantors, HashSet crashedGrantors) {
        super(dm, (Collection)others);
        this.grantors = grantors;
        this.crashedGrantors = crashedGrantors;
    }

    private synchronized void processData(ArrayList rmtGrantors, ArrayList rmtGrantorVersions, ArrayList rmtGrantorSerialNumbers, ArrayList rmtNonGrantors, InternalDistributedMember rmtId) {
        Iterator iterGrantorServices = rmtGrantors.iterator();
        Iterator iterGrantorVersions = rmtGrantorVersions.iterator();
        Iterator iterGrantorSerialNumbers = rmtGrantorSerialNumbers.iterator();
        while (iterGrantorServices.hasNext()) {
            String serviceName = (String)iterGrantorServices.next();
            long versionId = (Long)iterGrantorVersions.next();
            int serialNumber = (Integer)iterGrantorSerialNumbers.next();
            GrantorInfo oldgi = (GrantorInfo)this.grantors.get(serviceName);
            if (oldgi != null && oldgi.getVersionId() >= versionId) continue;
            this.grantors.put(serviceName, new GrantorInfo(rmtId, versionId, serialNumber, false));
            this.crashedGrantors.remove(serviceName);
        }
        for (String serviceName : rmtNonGrantors) {
            if (this.grantors.containsKey(serviceName)) continue;
            this.crashedGrantors.add(serviceName);
        }
    }

    @Override
    public void process(DistributionMessage msg) {
        if (msg instanceof ElderInitReplyMessage) {
            ElderInitReplyMessage eiMsg = (ElderInitReplyMessage)msg;
            this.processData(eiMsg.getGrantors(), eiMsg.getGrantorVersions(), eiMsg.getGrantorSerialNumbers(), eiMsg.getNonGrantors(), eiMsg.getSender());
        } else {
            Assert.assertTrue(false, "Expected instance of ElderInitReplyMessage but got " + msg.getClass());
        }
        super.process(msg);
    }

    public static class ElderInitReplyMessage
    extends ReplyMessage {
        private ArrayList grantors;
        private ArrayList grantorVersions;
        private ArrayList grantorSerialNumbers;
        private ArrayList nonGrantors;

        public static void send(MessageWithReply reqMsg, DistributionManager dm, ArrayList grantors, ArrayList grantorVersions, ArrayList grantorSerialNumbers, ArrayList nonGrantors) {
            ElderInitReplyMessage m = new ElderInitReplyMessage();
            m.grantors = grantors;
            m.grantorVersions = grantorVersions;
            m.grantorSerialNumbers = grantorSerialNumbers;
            m.nonGrantors = nonGrantors;
            m.processorId = reqMsg.getProcessorId();
            m.setRecipient(reqMsg.getSender());
            dm.putOutgoing(m);
        }

        public ArrayList getGrantors() {
            return this.grantors;
        }

        public ArrayList getGrantorVersions() {
            return this.grantorVersions;
        }

        public ArrayList getGrantorSerialNumbers() {
            return this.grantorSerialNumbers;
        }

        public ArrayList getNonGrantors() {
            return this.nonGrantors;
        }

        @Override
        public int getDSFID() {
            return 113;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.grantors = DataSerializer.readArrayList(in);
            this.grantorVersions = DataSerializer.readArrayList(in);
            this.grantorSerialNumbers = DataSerializer.readArrayList(in);
            this.nonGrantors = DataSerializer.readArrayList(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeArrayList(this.grantors, out);
            DataSerializer.writeArrayList(this.grantorVersions, out);
            DataSerializer.writeArrayList(this.grantorSerialNumbers, out);
            DataSerializer.writeArrayList(this.nonGrantors, out);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("ElderInitReplyMessage").append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; grantors=").append(this.grantors).append("; grantorVersions=").append(this.grantorVersions).append("; grantorSerialNumbers=").append(this.grantorSerialNumbers).append("; nonGrantors=").append(this.nonGrantors).append(")");
            return buff.toString();
        }
    }

    public static class ElderInitMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;

        protected static void send(Set others, DistributionManager dm, ReplyProcessor21 proc) {
            ElderInitMessage msg = new ElderInitMessage();
            msg.processorId = proc.getProcessorId();
            msg.setRecipients(others);
            if (logger.isTraceEnabled(LogMarker.DLS_VERBOSE)) {
                logger.trace(LogMarker.DLS_VERBOSE, "ElderInitMessage sending {} to {}", (Object)msg, (Object)others);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        private void reply(DistributionManager dm, ArrayList grantors, ArrayList grantorVersions, ArrayList grantorSerialNumbers, ArrayList nonGrantors) {
            ElderInitReplyMessage.send(this, dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            ArrayList grantors = new ArrayList();
            ArrayList grantorVersions = new ArrayList();
            ArrayList grantorSerialNumbers = new ArrayList();
            ArrayList nonGrantors = new ArrayList();
            try {
                if (dm.waitForElder(this.getSender())) {
                    GrantorRequestProcessor.readyForElderRecovery(dm.getSystem(), this.getSender(), null);
                    DLockService.recoverRmtElder(grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
                    this.reply(dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
                } else if (dm.getOtherNormalDistributionManagerIds().isEmpty()) {
                    logger.info(LogMarker.DLS_MARKER, "{}: returning empty lists because I know of no other members.", (Object)this);
                    this.reply(dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
                } else {
                    logger.info(LogMarker.DLS_MARKER, "{}: disregarding request from departed member.", (Object)this);
                }
            }
            catch (InterruptedException e) {
                logger.info("Elder initialization interrupted - will not send a reply");
            }
        }

        public int getDSFID() {
            return 112;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("ElderInitMessage (processorId=").append(this.processorId).append(")");
            return buff.toString();
        }
    }
}

