/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.adapter;

import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.internal.admin.remote.RemoteTransportConfig;
import org.apache.geode.internal.net.SocketCreator;

public class ServiceConfig
implements MembershipConfig {
    private final long joinTimeout;
    private final int[] membershipPortRange;
    private final long memberTimeout;
    private final boolean isReconnecting;
    private final Integer lossThreshold;
    private final Integer memberWeight;
    private final boolean networkPartitionDetectionEnabled;
    private final int locatorWaitTime;
    private final DistributionConfig dconfig;
    private final RemoteTransportConfig transport;
    private final boolean locatorsPreferredAsCoordinators;

    public ServiceConfig(RemoteTransportConfig transport, DistributionConfig theConfig) {
        long minimumJoinTimeout;
        this.dconfig = theConfig;
        this.transport = transport;
        this.isReconnecting = transport.getOldDSMembershipInfo() != null;
        long defaultJoinTimeout = 24000L;
        if (this.isReconnecting || theConfig.getLocators().length() > 0 && !Locator.hasLocator()) {
            defaultJoinTimeout = 60000L;
        }
        if (defaultJoinTimeout < (minimumJoinTimeout = (long)this.dconfig.getMemberTimeout() * 2L + MEMBER_REQUEST_COLLECTION_INTERVAL)) {
            defaultJoinTimeout = minimumJoinTimeout;
        }
        this.joinTimeout = Long.getLong("p2p.joinTimeout", defaultJoinTimeout);
        SocketCreator.resolve_dns = true;
        if (theConfig.getEnableNetworkPartitionDetection() && !SocketCreator.FORCE_DNS_USE) {
            SocketCreator.resolve_dns = false;
        }
        this.membershipPortRange = theConfig.getMembershipPortRange();
        this.memberTimeout = theConfig.getMemberTimeout();
        int configuredLossThreshold = Integer.getInteger("gemfire.network-partition-threshold", 51);
        this.lossThreshold = configuredLossThreshold < 51 ? Integer.valueOf(51) : (configuredLossThreshold > 100 ? Integer.valueOf(100) : Integer.valueOf(configuredLossThreshold));
        this.memberWeight = Integer.getInteger("gemfire.member-weight", 0);
        this.locatorWaitTime = theConfig.getLocatorWaitTime();
        this.networkPartitionDetectionEnabled = theConfig.getEnableNetworkPartitionDetection();
        this.locatorsPreferredAsCoordinators = ServiceConfig.determineLocatorsPreferredAsCoordinators(this.networkPartitionDetectionEnabled, this.dconfig);
    }

    private static boolean determineLocatorsPreferredAsCoordinators(boolean networkPartitionDetectionEnabled, DistributionConfig dconfig) {
        boolean locatorsAreCoordinators;
        if (networkPartitionDetectionEnabled) {
            locatorsAreCoordinators = true;
        } else {
            String prop = dconfig.getSecurityPeerAuthInit();
            boolean bl = locatorsAreCoordinators = prop != null && prop.length() > 0;
            if (!locatorsAreCoordinators) {
                locatorsAreCoordinators = Boolean.getBoolean("gemfire.disable-floating-coordinator");
            }
        }
        return locatorsAreCoordinators;
    }

    public boolean isReconnecting() {
        return this.isReconnecting;
    }

    public int getLocatorWaitTime() {
        return this.locatorWaitTime;
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public int[] getMembershipPortRange() {
        return this.membershipPortRange;
    }

    public long getMemberTimeout() {
        return this.memberTimeout;
    }

    public int getLossThreshold() {
        return this.lossThreshold;
    }

    public int getMemberWeight() {
        return this.memberWeight;
    }

    public boolean isMulticastEnabled() {
        return this.transport.isMcastEnabled();
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public boolean isUDPSecurityEnabled() {
        return !this.dconfig.getSecurityUDPDHAlgo().isEmpty();
    }

    public boolean areLocatorsPreferredAsCoordinators() {
        return this.locatorsPreferredAsCoordinators;
    }

    public String getSecurityUDPDHAlgo() {
        return this.dconfig.getSecurityUDPDHAlgo();
    }

    public int getMcastPort() {
        return this.dconfig.getMcastPort();
    }

    public String getLocators() {
        return this.dconfig.getLocators();
    }

    public String getStartLocator() {
        return this.dconfig.getStartLocator();
    }

    public boolean getEnableNetworkPartitionDetection() {
        return this.dconfig.getEnableNetworkPartitionDetection();
    }

    public String getBindAddress() {
        return this.dconfig.getBindAddress();
    }

    public String getSecurityPeerAuthInit() {
        return this.dconfig.getSecurityPeerAuthInit();
    }

    public boolean getDisableTcp() {
        return this.dconfig.getDisableTcp();
    }

    public String getName() {
        return this.dconfig.getName();
    }

    public String getRoles() {
        return this.dconfig.getRoles();
    }

    public String getGroups() {
        return this.dconfig.getGroups();
    }

    public String getDurableClientId() {
        return this.dconfig.getDurableClientId();
    }

    public int getDurableClientTimeout() {
        return this.dconfig.getDurableClientTimeout();
    }

    public String getMcastAddress() {
        return this.dconfig.getMcastAddress().getHostAddress();
    }

    public int getMcastTtl() {
        return this.dconfig.getMcastTtl();
    }

    public int getMcastSendBufferSize() {
        return this.dconfig.getMcastSendBufferSize();
    }

    public int getMcastRecvBufferSize() {
        return this.dconfig.getMcastRecvBufferSize();
    }

    public int getUdpFragmentSize() {
        return this.dconfig.getUdpFragmentSize();
    }

    public int getUdpRecvBufferSize() {
        return this.dconfig.getUdpRecvBufferSize();
    }

    public int getUdpSendBufferSize() {
        return this.dconfig.getUdpSendBufferSize();
    }

    public int getMcastByteAllowance() {
        return this.dconfig.getMcastFlowControl().getByteAllowance();
    }

    public float getMcastRechargeThreshold() {
        return this.dconfig.getMcastFlowControl().getRechargeThreshold();
    }

    public int getMcastRechargeBlockMs() {
        return this.dconfig.getMcastFlowControl().getRechargeBlockMs();
    }

    public long getAckWaitThreshold() {
        return this.dconfig.getAckWaitThreshold();
    }

    public boolean getDisableAutoReconnect() {
        return this.dconfig.getDisableAutoReconnect();
    }

    public int getSecurityPeerMembershipTimeout() {
        return this.dconfig.getSecurityPeerMembershipTimeout();
    }

    public long getAckSevereAlertThreshold() {
        return this.dconfig.getAckSevereAlertThreshold();
    }

    public int getVmKind() {
        return this.transport.getVmKind();
    }

    public Object getOldDSMembershipInfo() {
        return this.transport.getOldDSMembershipInfo();
    }

    public boolean getIsReconnectingDS() {
        return this.transport.getIsReconnectingDS();
    }

    public boolean getHasLocator() {
        return Locator.hasLocator();
    }
}

