/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProcessOutputReader {
    private int exitCode;
    private String output;

    public ProcessOutputReader(Process p) {
        final List<String> lines = Collections.synchronizedList(new ArrayList());
        class ProcessStreamReader
        extends Thread {
            private BufferedReader reader;
            public int linecount = 0;

            public ProcessStreamReader(InputStream stream) {
                this.reader = new BufferedReader(new InputStreamReader(stream));
            }

            @Override
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        ++this.linecount;
                        lines.add(line);
                    }
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ProcessStreamReader stdout = new ProcessStreamReader(p.getInputStream());
        ProcessStreamReader stderr = new ProcessStreamReader(p.getErrorStream());
        stdout.start();
        stderr.start();
        try {
            stderr.join();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        try {
            stdout.join();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        this.exitCode = 0;
        int retryCount = 9;
        while (retryCount > 0) {
            --retryCount;
            try {
                this.exitCode = p.exitValue();
                break;
            }
            catch (IllegalThreadStateException e) {
                if (retryCount == 0) {
                    if (stderr.linecount <= 0) continue;
                    lines.add("Failed to get exit status and it wrote to stderr so setting exit status to 1.");
                    this.exitCode = 1;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            pw.println((String)it.next());
        }
        pw.close();
        try {
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StringBuffer buf = sw.getBuffer();
        this.output = buf != null && buf.length() > 0 ? sw.toString() : "";
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output;
    }
}

