/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.internal.admin.StatAlertDefinition;
import org.apache.geode.internal.admin.StatAlertsManager;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class UpdateAlertDefinitionMessage
extends PooledDistributionMessage {
    public static final int ADD_ALERT_DEFINITION = 1;
    public static final int UPDATE_ALERT_DEFINITION = 2;
    public static final int REMOVE_ALERT_DEFINITION = 3;
    private StatAlertDefinition[] _alertDefinitions;
    private int _actionCode;

    public static UpdateAlertDefinitionMessage create(StatAlertDefinition[] alertDefs, int actionCode) {
        UpdateAlertDefinitionMessage m = new UpdateAlertDefinitionMessage();
        m._alertDefinitions = alertDefs;
        m._actionCode = actionCode;
        return m;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeByte(this._actionCode);
        DataSerializer.writeObjectArray(this._alertDefinitions, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this._actionCode = in.readByte();
        this._alertDefinitions = (StatAlertDefinition[])DataSerializer.readObjectArray(in);
    }

    public int getDSFID() {
        return 1066;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        StatAlertsManager.getInstance(dm).updateAlertDefinition(this._alertDefinitions, this._actionCode);
    }

    public StatAlertDefinition[] getAlertDefinitions() {
        return this._alertDefinitions;
    }

    public int getActionCode() {
        return this._actionCode;
    }

    public void updateAlertDefinition(StatAlertDefinition[] alertDefinitions, int actionCode) {
        this._alertDefinitions = alertDefinitions;
        this._actionCode = actionCode;
    }

    @Override
    public String toString() {
        InternalDistributedSystem internalDS = InternalDistributedSystem.getAnyInstance();
        String stringInfo = "";
        stringInfo = internalDS != null && internalDS.isConnected() ? "Add/update the alert definitions to " + internalDS.getDistributedMember() + " from " + this.getSender() : "InternalDistributedSystem instance not found, no connection with DistributedSystem.";
        return stringInfo;
    }
}

