/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.persistence.DiskStoreID;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.cache.persistence.PersistentMemberState;
import org.apache.geode.internal.cache.persistence.PersistentMemberView;

public class InMemoryPersistentMemberView
implements PersistentMemberView {
    private Map<PersistentMemberID, PersistentMemberState> members = new ConcurrentHashMap<PersistentMemberID, PersistentMemberState>();

    @Override
    public PersistentMemberID generatePersistentID() {
        return null;
    }

    @Override
    public PersistentMemberID getMyPersistentID() {
        return null;
    }

    @Override
    public Set<PersistentMemberID> getOfflineMembers() {
        HashSet<PersistentMemberID> offlineMembers = new HashSet<PersistentMemberID>();
        for (Map.Entry<PersistentMemberID, PersistentMemberState> entry : this.members.entrySet()) {
            if (entry.getValue() != PersistentMemberState.OFFLINE) continue;
            offlineMembers.add(entry.getKey());
        }
        return offlineMembers;
    }

    @Override
    public Set<PersistentMemberID> getOfflineAndEqualMembers() {
        HashSet<PersistentMemberID> equalMembers = new HashSet<PersistentMemberID>();
        for (Map.Entry<PersistentMemberID, PersistentMemberState> entry : this.members.entrySet()) {
            if (entry.getValue() != PersistentMemberState.EQUAL) continue;
            equalMembers.add(entry.getKey());
        }
        return equalMembers;
    }

    @Override
    public Set<PersistentMemberID> getOnlineMembers() {
        HashSet<PersistentMemberID> onlineMembers = new HashSet<PersistentMemberID>();
        for (Map.Entry<PersistentMemberID, PersistentMemberState> entry : this.members.entrySet()) {
            if (entry.getValue() != PersistentMemberState.ONLINE) continue;
            onlineMembers.add(entry.getKey());
        }
        return onlineMembers;
    }

    @Override
    public void memberOffline(PersistentMemberID persistentID) {
        this.members.put(persistentID, PersistentMemberState.OFFLINE);
    }

    @Override
    public void memberOfflineAndEqual(PersistentMemberID persistentID) {
        this.members.put(persistentID, PersistentMemberState.EQUAL);
    }

    @Override
    public void memberOnline(PersistentMemberID persistentID) {
        this.members.put(persistentID, PersistentMemberState.ONLINE);
    }

    @Override
    public void memberRemoved(PersistentMemberID persistentID) {
        this.members.remove(persistentID);
    }

    @Override
    public void setInitialized() {
    }

    @Override
    public PersistentMemberID getMyInitializingID() {
        return null;
    }

    @Override
    public void setInitializing(PersistentMemberID newId) {
    }

    @Override
    public void endDestroy(LocalRegion region) {
    }

    @Override
    public void beginDestroy(LocalRegion region) {
    }

    @Override
    public void beginDestroyDataStorage() {
    }

    @Override
    public void finishPendingDestroy() {
    }

    @Override
    public boolean wasAboutToDestroy() {
        return false;
    }

    @Override
    public boolean wasAboutToDestroyDataStorage() {
        return false;
    }

    @Override
    public DiskStoreID getDiskStoreID() {
        return null;
    }

    @Override
    public void memberRevoked(PersistentMemberPattern pattern) {
    }

    @Override
    public Set<PersistentMemberPattern> getRevokedMembers() {
        return Collections.emptySet();
    }
}

