/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.internal.cache.Oplog;

public class DiskStoreBackup {
    private final Set<Oplog> pendingBackup;
    private final Set<Oplog> deferredCrfDeletes = new HashSet<Oplog>();
    private final Set<Oplog> deferredDrfDeletes = new HashSet<Oplog>();

    DiskStoreBackup(Oplog[] allOplogs) {
        this.pendingBackup = new HashSet<Oplog>(Arrays.asList(allOplogs));
    }

    synchronized boolean deferCrfDelete(Oplog oplog) {
        if (this.pendingBackup.contains(oplog)) {
            this.deferredCrfDeletes.add(oplog);
            return true;
        }
        return false;
    }

    synchronized boolean deferDrfDelete(Oplog oplog) {
        if (this.pendingBackup.contains(oplog)) {
            this.deferredDrfDeletes.add(oplog);
            return true;
        }
        return false;
    }

    synchronized Set<Oplog> getPendingBackup() {
        return new HashSet<Oplog>(this.pendingBackup);
    }

    synchronized void backupFinished(Oplog oplog) {
        this.pendingBackup.remove(oplog);
        if (this.deferredCrfDeletes.remove(oplog)) {
            oplog.deleteCRFFileOnly();
        }
        if (this.deferredDrfDeletes.remove(oplog)) {
            oplog.deleteDRFFileOnly();
        }
    }

    synchronized void cleanup() {
        for (Oplog oplog : this.getPendingBackup()) {
            this.backupFinished(oplog);
        }
    }
}

