/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;

public class RebalanceResultsImpl
implements RebalanceResults,
Serializable {
    private Set<PartitionRebalanceInfo> detailSet = new TreeSet<PartitionRebalanceInfo>();
    private long totalBucketCreateBytes;
    private long totalBucketCreateTime;
    private int totalBucketCreatesCompleted;
    private long totalBucketTransferBytes;
    private long totalBucketTransferTime;
    private int totalBucketTransfersCompleted;
    private long totalPrimaryTransferTime;
    private int totalPrimaryTransfersCompleted;
    private long totalTime;

    public void addDetails(PartitionRebalanceInfo details) {
        this.detailSet.add(details);
        this.totalBucketCreateBytes += details.getBucketCreateBytes();
        this.totalBucketCreateTime += details.getBucketCreateTime();
        this.totalBucketCreatesCompleted += details.getBucketCreatesCompleted();
        this.totalBucketTransferBytes += details.getBucketTransferBytes();
        this.totalBucketTransferTime += details.getBucketTransferTime();
        this.totalBucketTransfersCompleted += details.getBucketTransfersCompleted();
        this.totalPrimaryTransferTime += details.getPrimaryTransferTime();
        this.totalPrimaryTransfersCompleted += details.getPrimaryTransfersCompleted();
        this.totalTime += details.getTime();
    }

    public void addDetails(RebalanceResultsImpl details) {
        this.detailSet.addAll(details.detailSet);
        this.totalBucketCreateBytes += details.totalBucketCreateBytes;
        this.totalBucketCreateTime += details.totalBucketCreateTime;
        this.totalBucketCreatesCompleted += details.totalBucketCreatesCompleted;
        this.totalBucketTransferBytes += details.totalBucketTransferBytes;
        this.totalBucketTransferTime += details.totalBucketTransferTime;
        this.totalBucketTransfersCompleted += details.totalBucketTransfersCompleted;
        this.totalPrimaryTransferTime += details.totalPrimaryTransferTime;
        this.totalPrimaryTransfersCompleted += details.totalPrimaryTransfersCompleted;
        if (details.totalTime > this.totalTime) {
            this.totalTime = details.totalTime;
        }
    }

    @Override
    public Set<PartitionRebalanceInfo> getPartitionRebalanceDetails() {
        return this.detailSet;
    }

    @Override
    public long getTotalBucketCreateBytes() {
        return this.totalBucketCreateBytes;
    }

    @Override
    public long getTotalBucketCreateTime() {
        return this.totalBucketCreateTime;
    }

    @Override
    public int getTotalBucketCreatesCompleted() {
        return this.totalBucketCreatesCompleted;
    }

    @Override
    public long getTotalBucketTransferBytes() {
        return this.totalBucketTransferBytes;
    }

    @Override
    public long getTotalBucketTransferTime() {
        return this.totalBucketTransferTime;
    }

    @Override
    public int getTotalBucketTransfersCompleted() {
        return this.totalBucketTransfersCompleted;
    }

    @Override
    public long getTotalPrimaryTransferTime() {
        return this.totalPrimaryTransferTime;
    }

    @Override
    public int getTotalPrimaryTransfersCompleted() {
        return this.totalPrimaryTransfersCompleted;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    public String toString() {
        return "{totalBucketCreateBytes=" + this.totalBucketCreateBytes + ", totalBucketCreateTimeInMilliseconds=" + this.totalBucketCreateTime + ", totalBucketCreatesCompleted=" + this.totalBucketCreatesCompleted + ", totalBucketTransferBytes=" + this.totalBucketTransferBytes + ", totalBucketTransferTimeInMilliseconds=" + this.totalBucketTransferTime + ", totalBucketTransfersCompleted=" + this.totalBucketTransfersCompleted + ", totalPrimaryTransferTimeInMilliseconds=" + this.totalPrimaryTransferTime + ", totalPrimaryTransfersCompleted=" + this.totalPrimaryTransfersCompleted + ", totalTimeInMilliseconds=" + this.totalTime + "}";
    }
}

