/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.PartitionedRegionStorageException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CreateBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private int bucketSize;

    public CreateBucketMessage() {
    }

    private CreateBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, int bucketSize) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.bucketSize = bucketSize;
    }

    public CreateBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static NodeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId, int bucketSize) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "CreateBucketMessage NULL recipient");
        NodeResponse p = new NodeResponse(r.getSystem(), recipient);
        CreateBucketMessage m = new CreateBucketMessage(recipient, r.getPRId(), p, bucketId, bucketSize);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        p.enableSevereAlertProcessing();
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + m + ">");
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) {
        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
            logger.trace(LogMarker.DM_VERBOSE, "CreateBucketMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        if (!r.isInitialized()) {
            CreateBucketReplyMessage.sendResponse(this.getSender(), this.getProcessorId(), dm, null);
            return false;
        }
        String partitionName = null;
        if (r.isFixedPartitionedRegion()) {
            FixedPartitionAttributesImpl fpa = PartitionedRegionHelper.getFixedPartitionAttributesForBucket(r, this.bucketId);
            partitionName = fpa.getPartitionName();
        }
        r.checkReadiness();
        InternalDistributedMember primary = r.getRedundancyProvider().createBucketAtomically(this.bucketId, this.bucketSize, false, partitionName);
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        CreateBucketReplyMessage.sendResponse(this.getSender(), this.getProcessorId(), dm, primary);
        return false;
    }

    public int getDSFID() {
        return -106;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.bucketId = in.readInt();
        this.bucketSize = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.bucketId);
        out.writeInt(this.bucketSize);
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId).append("; bucketSize=").append(this.bucketSize);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static class NodeResponse
    extends ReplyProcessor21 {
        private volatile CreateBucketReplyMessage msg;

        public NodeResponse(InternalDistributedSystem ds, InternalDistributedMember recipient) {
            super(ds, recipient);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof CreateBucketReplyMessage) {
                    CreateBucketReplyMessage reply;
                    this.msg = reply = (CreateBucketReplyMessage)msg;
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "NodeResponse return value is ");
                    }
                } else {
                    Assert.assertTrue(msg instanceof ReplyMessage);
                }
            }
            finally {
                super.process(msg);
            }
        }

        public InternalDistributedMember waitForResponse() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("NodeResponse got remote cancellation, throwing PartitionedRegionCommunication Exception {}", (Object)t.getMessage(), (Object)t);
                    return null;
                }
                if (t instanceof PRLocallyDestroyedException) {
                    logger.debug("NodeResponse got local destroy on the PartitionRegion , throwing ForceReattemptException {}", (Object)t.getMessage(), (Object)t);
                    return null;
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("NodeResponse got ForceReattemptException due to local destroy on the PartitionRegion {}", (Object)t.getMessage(), (Object)t);
                    return null;
                }
                if (t instanceof PartitionedRegionStorageException) {
                    throw new PartitionedRegionStorageException(t.getMessage(), t);
                }
                e.handleCause();
            }
            CreateBucketReplyMessage message = this.msg;
            if (message == null) {
                return null;
            }
            return message.primary;
        }
    }

    public static class CreateBucketReplyMessage
    extends ReplyMessage {
        private InternalDistributedMember primary;

        public CreateBucketReplyMessage() {
        }

        public CreateBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
        }

        private CreateBucketReplyMessage(int processorId, InternalDistributedMember primary) {
            this.setProcessorId(processorId);
            this.primary = primary;
        }

        public static void sendResponse(InternalDistributedMember recipient, int processorId, DistributionManager dm, InternalDistributedMember primary) {
            Assert.assertTrue(recipient != null, "CreateBucketReplyMessage NULL reply message");
            CreateBucketReplyMessage m = new CreateBucketReplyMessage(processorId, primary);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "CreateBucketReplyMessage process invoking reply processor with processorId:" + this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "CreateBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeBoolean(this.primary != null);
            if (this.primary != null) {
                InternalDataSerializer.invokeToData(this.primary, out);
            }
        }

        @Override
        public int getDSFID() {
            return -105;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            boolean hasPrimary = in.readBoolean();
            if (hasPrimary) {
                this.primary = new InternalDistributedMember();
                InternalDataSerializer.invokeFromData(this.primary, in);
            }
        }

        @Override
        public String toString() {
            return new StringBuffer().append("CreateBucketReplyMessage ").append("processorid=").append(this.processorId).toString();
        }
    }
}

