/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.io.Filter;
import org.apache.geode.internal.sequencelog.model.GraphReaderCallback;

public class InputStreamReader {
    private DataInputStream input;

    public InputStreamReader(InputStream stream) {
        this.input = new DataInputStream(new BufferedInputStream(stream));
    }

    public void addToGraphs(GraphReaderCallback set, Filter filter) throws IOException {
        byte recordType;
        ArrayList<String> strings = new ArrayList<String>();
        block5: while (true) {
            recordType = (byte)this.input.read();
            switch (recordType) {
                case 2: {
                    strings.add(this.input.readUTF());
                    continue block5;
                }
                case 1: {
                    long timestamp = this.input.readLong();
                    GraphType graphType = GraphType.getType(this.input.readByte());
                    boolean isPattern = this.input.readBoolean();
                    String graphName = null;
                    Pattern graphPattern = null;
                    if (isPattern) {
                        String pattern = this.input.readUTF();
                        int flags = this.input.readInt();
                        graphPattern = Pattern.compile(pattern, flags);
                    } else {
                        graphName = this.input.readUTF();
                        graphName = graphName.intern();
                    }
                    String stateName = this.input.readUTF();
                    stateName = stateName.intern();
                    String edgeName = this.readCanonicalString(strings);
                    String source = this.readCanonicalString(strings);
                    String dest = this.readCanonicalString(strings);
                    if (isPattern) {
                        if (!filter.acceptPattern(graphType, graphPattern, edgeName, source, dest)) continue block5;
                        set.addEdgePattern(timestamp, graphType, graphPattern, edgeName, stateName, source, dest);
                        continue block5;
                    }
                    if (!filter.accept(graphType, graphName, edgeName, source, dest)) continue block5;
                    set.addEdge(timestamp, graphType, graphName, edgeName, stateName, source, dest);
                    continue block5;
                }
                case -1: {
                    return;
                }
            }
            break;
        }
        throw new IOException("Unknown record type " + recordType);
    }

    private String readCanonicalString(List<String> strings) throws IOException {
        int index = this.input.readInt();
        if (index == -1) {
            return null;
        }
        return strings.get(index);
    }
}

