/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.admin.SSLConfig;

public class SSLUtil {
    public static SSLContext getSSLContextInstance(SSLConfig sslConfig) {
        String[] knownAlgorithms;
        String[] protocols = sslConfig.getProtocolsAsStringArray();
        SSLContext sslContext = null;
        if (protocols != null && protocols.length > 0) {
            for (String protocol : protocols) {
                if (protocol.equals("any")) continue;
                try {
                    sslContext = SSLContext.getInstance(protocol);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        if (sslContext != null) {
            return sslContext;
        }
        for (String algo : knownAlgorithms = new String[]{"SSL", "SSLv2", "SSLv3", "TLS", "TLSv1", "TLSv1.1", "TLSv1.2"}) {
            try {
                sslContext = SSLContext.getInstance(algo);
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        return sslContext;
    }

    public static String[] readArray(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return text.split("[\\s,]+");
    }

    public static SSLContext createAndConfigureSSLContext(SSLConfig sslConfig, boolean skipSslVerification) {
        try {
            if (sslConfig.useDefaultSSLContext()) {
                return SSLContext.getDefault();
            }
            SSLContext ssl = SSLUtil.getSSLContextInstance(sslConfig);
            KeyManager[] keyManagers = SSLUtil.getKeyManagers(sslConfig);
            TrustManager[] trustManagers = SSLUtil.getTrustManagers(sslConfig, skipSslVerification);
            ssl.init(keyManagers, trustManagers, new SecureRandom());
            return ssl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManager[] getKeyManagers(SSLConfig sslConfig) throws Exception {
        KeyManagerFactory keyManagerFactory = null;
        try (FileInputStream keyStoreStream = null;){
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getKeystore())) {
                String keyStoreType = Objects.toString(sslConfig.getKeystoreType(), "JKS");
                KeyStore clientKeys = KeyStore.getInstance(keyStoreType);
                keyStoreStream = new FileInputStream(sslConfig.getKeystore());
                clientKeys.load(keyStoreStream, sslConfig.getKeystorePassword().toCharArray());
                keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(clientKeys, sslConfig.getKeystorePassword().toCharArray());
            }
        }
        return keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManager[] getTrustManagers(SSLConfig sslConfig, boolean skipSslVerification) throws Exception {
        FileInputStream trustStoreStream = null;
        TrustManagerFactory trustManagerFactory = null;
        if (skipSslVerification) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            return trustAllCerts;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getTruststore())) {
                String trustStoreType = Objects.toString(sslConfig.getTruststoreType(), "JKS");
                KeyStore serverPub = KeyStore.getInstance(trustStoreType);
                trustStoreStream = new FileInputStream(sslConfig.getTruststore());
                serverPub.load(trustStoreStream, sslConfig.getTruststorePassword().toCharArray());
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(serverPub);
            }
        }
        finally {
            if (trustStoreStream != null) {
                trustStoreStream.close();
            }
        }
        return trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
    }
}

