/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.ManagementConstants;

public class DistributedLockServiceBridge {
    private Map<ObjectName, LockServiceMXBean> mapOfProxy = new ConcurrentHashMap<ObjectName, LockServiceMXBean>();
    private List<String> listHeldLock = new ArrayList<String>();
    private Map<String, String> threadsHoldingLock = new HashMap<String, String>();
    private volatile int setSize;

    public DistributedLockServiceBridge(ObjectName objectName, LockServiceMXBean proxy, FederationComponent newState) {
        this.addProxyToMap(objectName, proxy);
    }

    public void addProxyToMap(ObjectName objectName, LockServiceMXBean proxy) {
        if (this.mapOfProxy != null) {
            this.mapOfProxy.put(objectName, proxy);
            this.setSize = this.mapOfProxy.values().size();
        }
    }

    public boolean removeProxyFromMap(ObjectName objectName, LockServiceMXBean proxy) {
        if (this.mapOfProxy != null) {
            this.mapOfProxy.remove(objectName);
            this.setSize = this.mapOfProxy.values().size();
            if (this.mapOfProxy.values().size() == 0) {
                this.setSize = 0;
                return true;
            }
        }
        return false;
    }

    public String fetchGrantorMember() {
        Iterator<LockServiceMXBean> it = this.mapOfProxy.values().iterator();
        if (it != null && it.hasNext()) {
            String grantorMember = it.next().fetchGrantorMember();
            return grantorMember;
        }
        return null;
    }

    public int getMemberCount() {
        return this.setSize;
    }

    public String[] getMemberNames() {
        Iterator<LockServiceMXBean> it = this.mapOfProxy.values().iterator();
        if (it != null && it.hasNext()) {
            String[] memberNames = it.next().getMemberNames();
            return memberNames;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String getName() {
        Iterator<LockServiceMXBean> it = this.mapOfProxy.values().iterator();
        if (it != null && it.hasNext()) {
            String name = it.next().getName();
            return name;
        }
        return null;
    }

    public String[] listHeldLocks() {
        Iterator<LockServiceMXBean> it = this.mapOfProxy.values().iterator();
        this.listHeldLock.clear();
        if (it != null) {
            while (it.hasNext()) {
                String[] locks = it.next().listHeldLocks();
                if (locks == null || locks.length <= 0) continue;
                for (String lock : locks) {
                    this.listHeldLock.add(lock);
                }
            }
        }
        String[] tmpStr = new String[this.listHeldLock.size()];
        return this.listHeldLock.toArray(tmpStr);
    }

    public Map<String, String> listThreadsHoldingLock() {
        Iterator<LockServiceMXBean> it = this.mapOfProxy.values().iterator();
        this.threadsHoldingLock.clear();
        if (it != null) {
            while (it.hasNext()) {
                Map<String, String> threadLockMap = it.next().listThreadsHoldingLock();
                if (threadLockMap == null) continue;
                this.threadsHoldingLock.putAll(threadLockMap);
            }
        }
        return this.threadsHoldingLock;
    }
}

