/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.geode.distributed.Locator;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.JmxManagerAdvisor;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.logging.log4j.Logger;

public class LocatorMBeanBridge {
    private static final Logger logger = LogService.getLogger();
    private Locator loc;
    private InternalCache cache;

    public LocatorMBeanBridge(Locator loc) {
        this.loc = loc;
        this.cache = GemFireCacheImpl.getInstance();
    }

    public String getBindAddress() {
        InetAddress bindAddress = this.loc.getBindAddress();
        return bindAddress != null ? bindAddress.getCanonicalHostName() : null;
    }

    public String getHostnameForClients() {
        return this.loc.getHostnameForClients();
    }

    public String viewLog() {
        return this.fetchLog(this.loc.getLogFile(), 30);
    }

    public int getPort() {
        return this.loc.getPort();
    }

    public boolean isPeerLocator() {
        return true;
    }

    public boolean isServerLocator() {
        return true;
    }

    public String[] listManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> alreadyManaging;
        if (this.cache != null && !(alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging()).isEmpty()) {
            String[] managers = new String[alreadyManaging.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : alreadyManaging) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listPotentialManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> willingToManage;
        if (this.cache != null && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            String[] managers = new String[willingToManage.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : willingToManage) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    private String fetchLog(File logFile, int numLines) {
        if (numLines > 100) {
            numLines = 100;
        }
        if (numLines == 0 || numLines < 0) {
            numLines = 30;
        }
        String mainTail = null;
        try {
            mainTail = BeanUtilFuncs.tailSystemLog(logFile, numLines);
            if (mainTail == null) {
                mainTail = "No log file was specified in the configuration, messages is being directed to stdout.";
            }
        }
        catch (IOException e) {
            logger.warn("Error occurred while reading log file: ", (Throwable)e);
            mainTail = "";
        }
        StringBuffer result = new StringBuffer();
        if (mainTail != null) {
            result.append(mainTail);
        }
        return result.toString();
    }
}

