/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.management.EvictionAttributesData;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.beans.stats.StatsAggregator;

public class RegionClusterStatsMonitor {
    private static final String CACHE_LISTENER_CALLS_AVG_LATENCY = "CacheListenerCallsAvgLatency";
    private static final String CACHE_WRITER_CALLS_AVG_LATENCY = "CacheWriterCallsAvgLatency";
    private static final String CREATES_RATE = "CreatesRate";
    private static final String DESTROY_RATE = "DestroyRate";
    private static final String DISK_READS_RATES = "DiskReadsRate";
    private static final String DISK_WRITES_RATES = "DiskWritesRate";
    private static final String GETS_RATE = "GetsRate";
    private static final String HIT_COUNT = "HitCount";
    private static final String MISS_COUNT = "MissCount";
    private static final String HIT_RATIO = "HitRatio";
    private static final String LAST_ACCESSED_TIME = "LastAccessedTime";
    private static final String LAST_MODIFIED_TIME = "LastModifiedTime";
    private static final String LRU_DESTROY_RATE = "LruDestroyRate";
    private static final String LRU_EVICTION_RATE = "LruEvictionRate";
    private static final String PUT_ALL_RATE = "PutAllRate";
    private static final String PUT_LOCAL_RATE = "PutLocalRate";
    private static final String PUT_REMOTE_AVG_LATENCY = "PutRemoteAvgLatency";
    private static final String PUT_REMOTE_LATENCY = "PutRemoteLatency";
    private static final String PUT_REMOTE_RATE = "PutRemoteRate";
    private static final String PUTS_RATE = "PutsRate";
    private static final String ENTRY_COUNT = "EntryCount";
    private static final String TOTAL_DISK_WRITES_IN_PROGRESS = "TotalDiskWritesProgress";
    private static final String TOTAL_BYTES_ON_DISK = "TotalBytesOnDisk";
    private static final String TOTAL_DISK_ENTRIES_IN_VM = "TotalDiskEntriesInVM";
    private static final String TOTAL_ENTRIES_ONLY_ON_DISK = "TotalEntriesOnlyOnDisk";
    private static final String AVERAGE_BUCKET_SIZE = "AvgBucketSize";
    private static final String BUCKET_COUNT = "BucketCount";
    private static final String NUM_BUCKESTS_WITHOUT_REDUNDANCY = "NumBucketsWithoutRedundancy";
    private static final String PRIMARY_BUCKET_COUNT = "PrimaryBucketCount";
    private static final String TOTAL_BUCKET_SIZE = "TotalBucketSize";
    private static final String DISK_TASK_WAITING = "DiskTaskWaiting";
    private static final String DISK_USAGE = "DiskUsage";
    private static final String AVERAGE_READS = "AverageReads";
    private static final String AVERAGE_WRITES = "AverageWrites";
    private static final String ENTRY_SIZE = "EntrySize";
    private static final String REGION_NAME = "Name";
    private static final String PARENT_REGION_NAME = "ParentRegion";
    private static final String REGION_TYPE = "RegionType";
    private static final String FULL_PATH = "FullPath";
    private static final String GATEWAY_ENABLED = "GatewayEnabled";
    private static final String PERSISTENT_ENABLED = "PersistentEnabled";
    private volatile long lastAccessedTime = 0L;
    private volatile long lastModifiedTime = 0L;
    private String regionName;
    private String parentRegion;
    private String regionType;
    private String fullPath;
    private Boolean gatewayEnabled;
    private Boolean persistentEnabled;
    private long entryCount = 0L;
    private volatile int numBucketsWithoutRedundancy = 0;
    private EvictionAttributesData evictionAttributesData;
    private StatsAggregator aggregator;
    private Map<String, Class<?>> typeMap = new HashMap();

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.aggregator.aggregate(newState, oldState);
        this.incLastAccessedTime(newState, oldState);
        this.incLastModifiedTime(newState, oldState);
        this.incNumBucketsWithoutRedundancy(newState, oldState);
        this.updateEntryCount(newState, oldState);
        this.setFixedAttributes(newState, oldState);
    }

    public RegionClusterStatsMonitor() {
        this.intTypeMap();
        this.aggregator = new StatsAggregator(this.typeMap);
    }

    private void intTypeMap() {
        this.typeMap.put(CACHE_LISTENER_CALLS_AVG_LATENCY, Long.TYPE);
        this.typeMap.put(CACHE_WRITER_CALLS_AVG_LATENCY, Long.TYPE);
        this.typeMap.put(CREATES_RATE, Float.TYPE);
        this.typeMap.put(DESTROY_RATE, Float.TYPE);
        this.typeMap.put(DISK_READS_RATES, Float.TYPE);
        this.typeMap.put(DISK_WRITES_RATES, Float.TYPE);
        this.typeMap.put(GETS_RATE, Float.TYPE);
        this.typeMap.put(HIT_COUNT, Long.TYPE);
        this.typeMap.put(MISS_COUNT, Long.TYPE);
        this.typeMap.put(HIT_RATIO, Float.TYPE);
        this.typeMap.put(LRU_DESTROY_RATE, Float.TYPE);
        this.typeMap.put(LRU_EVICTION_RATE, Float.TYPE);
        this.typeMap.put(PUT_ALL_RATE, Float.TYPE);
        this.typeMap.put(PUT_LOCAL_RATE, Float.TYPE);
        this.typeMap.put(PUT_REMOTE_AVG_LATENCY, Long.TYPE);
        this.typeMap.put(PUT_REMOTE_LATENCY, Long.TYPE);
        this.typeMap.put(PUT_REMOTE_RATE, Float.TYPE);
        this.typeMap.put(PUTS_RATE, Float.TYPE);
        this.typeMap.put(TOTAL_DISK_WRITES_IN_PROGRESS, Long.TYPE);
        this.typeMap.put(TOTAL_BYTES_ON_DISK, Long.TYPE);
        this.typeMap.put(TOTAL_DISK_ENTRIES_IN_VM, Long.TYPE);
        this.typeMap.put(TOTAL_ENTRIES_ONLY_ON_DISK, Long.TYPE);
        this.typeMap.put(ENTRY_COUNT, Long.TYPE);
        this.typeMap.put(AVERAGE_BUCKET_SIZE, Integer.TYPE);
        this.typeMap.put(BUCKET_COUNT, Integer.TYPE);
        this.typeMap.put(PRIMARY_BUCKET_COUNT, Integer.TYPE);
        this.typeMap.put(TOTAL_BUCKET_SIZE, Integer.TYPE);
        this.typeMap.put(DISK_TASK_WAITING, Long.TYPE);
        this.typeMap.put(DISK_USAGE, Long.TYPE);
        this.typeMap.put(AVERAGE_READS, Float.TYPE);
        this.typeMap.put(AVERAGE_WRITES, Float.TYPE);
        this.typeMap.put(ENTRY_SIZE, Long.TYPE);
    }

    private void incLastAccessedTime(FederationComponent newState, FederationComponent oldState) {
        if (newState != null && newState.getValue(LAST_ACCESSED_TIME) != null) {
            this.lastAccessedTime = (Long)newState.getValue(LAST_ACCESSED_TIME);
        }
    }

    private void incNumBucketsWithoutRedundancy(FederationComponent newState, FederationComponent oldState) {
        if (newState != null && newState.getValue(NUM_BUCKESTS_WITHOUT_REDUNDANCY) != null) {
            this.numBucketsWithoutRedundancy = (Integer)newState.getValue(NUM_BUCKESTS_WITHOUT_REDUNDANCY);
        }
    }

    private void incLastModifiedTime(FederationComponent newState, FederationComponent oldState) {
        if (newState != null && newState.getValue(LAST_MODIFIED_TIME) != null) {
            this.lastModifiedTime = (Long)newState.getValue(LAST_MODIFIED_TIME);
        }
    }

    private void updateEntryCount(FederationComponent newState, FederationComponent oldState) {
        if (newState != null && newState.getValue(ENTRY_COUNT) != null) {
            this.entryCount = (Long)newState.getValue(ENTRY_COUNT);
        }
    }

    public long getCacheListenerCallsAvgLatency() {
        return this.aggregator.getLongValue(CACHE_LISTENER_CALLS_AVG_LATENCY);
    }

    public long getCacheWriterCallsAvgLatency() {
        return this.aggregator.getLongValue(CACHE_WRITER_CALLS_AVG_LATENCY);
    }

    public float getCreatesRate() {
        return this.aggregator.getFloatValue(CREATES_RATE).floatValue();
    }

    public float getDestroyRate() {
        return this.aggregator.getFloatValue(DESTROY_RATE).floatValue();
    }

    public float getDiskReadsRate() {
        return this.aggregator.getFloatValue(DISK_READS_RATES).floatValue();
    }

    public float getDiskWritesRate() {
        return this.aggregator.getFloatValue(DISK_WRITES_RATES).floatValue();
    }

    public float getGetsRate() {
        return this.aggregator.getFloatValue(GETS_RATE).floatValue();
    }

    public long getHitCount() {
        return this.aggregator.getLongValue(HIT_COUNT);
    }

    public float getHitRatio() {
        return this.aggregator.getFloatValue(HIT_COUNT).floatValue();
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public float getLruDestroyRate() {
        return this.aggregator.getFloatValue(LRU_DESTROY_RATE).floatValue();
    }

    public float getLruEvictionRate() {
        return this.aggregator.getFloatValue(LRU_EVICTION_RATE).floatValue();
    }

    public long getMissCount() {
        return this.aggregator.getLongValue(MISS_COUNT);
    }

    public float getPutAllRate() {
        return this.aggregator.getFloatValue(PUT_ALL_RATE).floatValue();
    }

    public float getPutLocalRate() {
        return this.aggregator.getFloatValue(PUT_LOCAL_RATE).floatValue();
    }

    public long getPutRemoteAvgLatency() {
        return this.aggregator.getLongValue(PUT_REMOTE_AVG_LATENCY);
    }

    public long getPutRemoteLatency() {
        return this.aggregator.getLongValue(PUT_REMOTE_LATENCY);
    }

    public float getPutRemoteRate() {
        return this.aggregator.getFloatValue(PUT_REMOTE_RATE).floatValue();
    }

    public float getPutsRate() {
        return this.aggregator.getFloatValue(PUTS_RATE).floatValue();
    }

    public long getSystemRegionEntryCount() {
        return this.aggregator.getLongValue(ENTRY_COUNT);
    }

    public long getTotalDiskWritesProgress() {
        return this.aggregator.getLongValue(TOTAL_DISK_WRITES_IN_PROGRESS);
    }

    public long getTotalBytesOnDisk() {
        return this.aggregator.getLongValue(TOTAL_BYTES_ON_DISK);
    }

    public long getTotalDiskEntriesInVM() {
        return this.aggregator.getLongValue(TOTAL_DISK_ENTRIES_IN_VM);
    }

    public long getTotalEntriesOnlyOnDisk() {
        return this.aggregator.getLongValue(TOTAL_ENTRIES_ONLY_ON_DISK);
    }

    public int getAvgBucketSize() {
        int bucketNum = this.getBucketCount();
        if (bucketNum > 0) {
            return this.getTotalBucketSize() / bucketNum;
        }
        return 0;
    }

    public int getBucketCount() {
        return this.aggregator.getIntValue(BUCKET_COUNT);
    }

    public int getNumBucketsWithoutRedundancy() {
        return this.numBucketsWithoutRedundancy;
    }

    public int getPrimaryBucketCount() {
        return this.aggregator.getIntValue(PRIMARY_BUCKET_COUNT);
    }

    public int getTotalBucketSize() {
        return this.aggregator.getIntValue(TOTAL_BUCKET_SIZE);
    }

    public long getDiskTaskWaiting() {
        return this.aggregator.getLongValue(DISK_TASK_WAITING);
    }

    public long getDiskUsage() {
        return this.aggregator.getLongValue(DISK_USAGE);
    }

    public float getAverageReads() {
        return this.aggregator.getFloatValue(AVERAGE_READS).floatValue();
    }

    public float getAverageWrites() {
        return this.aggregator.getFloatValue(AVERAGE_WRITES).floatValue();
    }

    public long getEntrySize() {
        return this.aggregator.getLongValue(ENTRY_SIZE);
    }

    private void setFixedAttributes(FederationComponent newState, FederationComponent oldState) {
        if (this.regionName == null && newState != null && newState.getValue(REGION_NAME) != null) {
            this.regionName = (String)newState.getValue(REGION_NAME);
        }
        if (this.parentRegion == null && newState != null && newState.getValue(PARENT_REGION_NAME) != null) {
            this.parentRegion = (String)newState.getValue(PARENT_REGION_NAME);
        }
        if (this.regionType == null && newState != null && newState.getValue(REGION_TYPE) != null) {
            this.regionType = (String)newState.getValue(REGION_TYPE);
        }
        if (this.fullPath == null && newState != null && newState.getValue(FULL_PATH) != null) {
            this.fullPath = (String)newState.getValue(FULL_PATH);
        }
        if (this.gatewayEnabled == null && newState != null && newState.getValue(GATEWAY_ENABLED) != null) {
            this.gatewayEnabled = (Boolean)newState.getValue(GATEWAY_ENABLED);
        }
        if (this.persistentEnabled == null && newState != null && newState.getValue(PERSISTENT_ENABLED) != null) {
            this.persistentEnabled = (Boolean)newState.getValue(PERSISTENT_ENABLED);
        }
    }

    public String getName() {
        return this.regionName;
    }

    public String getParentRegion() {
        return this.parentRegion;
    }

    public String getRegionType() {
        return this.regionType;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public boolean isGatewayEnabled() {
        return this.gatewayEnabled;
    }

    public boolean isPersistentEnabled() {
        return this.persistentEnabled;
    }

    public long getEntryCount() {
        return this.entryCount;
    }
}

