/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.concurrent.TimeUnit;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.internal.statistics.StatisticId;
import org.apache.geode.internal.statistics.StatisticNotFoundException;
import org.apache.geode.internal.statistics.StatisticsNotification;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;

public class VMStatsMonitor
extends MBeanStatsMonitor {
    static final int VALUE_NOT_AVAILABLE = -1;
    private static final String PROCESS_CPU_TIME_ATTRIBUTE = "ProcessCpuTime";
    private long lastSystemTime = 0L;
    private long lastProcessCpuTime = 0L;
    private volatile float cpuUsage = 0.0f;
    private final boolean processCPUTimeAvailable;

    public float getCpuUsage() {
        return this.cpuUsage;
    }

    long getLastSystemTime() {
        return this.lastSystemTime;
    }

    long getLastProcessCpuTime() {
        return this.lastProcessCpuTime;
    }

    public VMStatsMonitor(String name, boolean processCPUTimeAvailable) {
        super(name);
        this.processCPUTimeAvailable = processCPUTimeAvailable;
        if (!processCPUTimeAvailable) {
            this.cpuUsage = -1.0f;
        }
    }

    public VMStatsMonitor(String name) {
        this(name, MBeanJMXAdapter.isAttributeAvailable(PROCESS_CPU_TIME_ATTRIBUTE, "java.lang:type=OperatingSystem"));
    }

    long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    float calculateCpuUsage(long systemTime, long cpuTime) {
        long denom = (systemTime - this.getLastSystemTime()) * 10000L;
        return (float)(cpuTime - this.getLastProcessCpuTime()) / (float)denom;
    }

    synchronized void refreshStats() {
        if (this.processCPUTimeAvailable) {
            Number processCpuTime = this.statsMap.getOrDefault("processCpuTime", 0);
            if (processCpuTime == null) {
                this.cpuUsage = -1.0f;
                return;
            }
            if (this.lastSystemTime == 0L) {
                this.lastSystemTime = this.currentTimeMillis();
                return;
            }
            long cpuTime = processCpuTime.longValue();
            if (this.lastProcessCpuTime == 0L) {
                this.lastProcessCpuTime = cpuTime;
                return;
            }
            long systemTime = this.currentTimeMillis();
            this.cpuUsage = this.calculateCpuUsage(systemTime, cpuTime);
            this.lastSystemTime = systemTime;
            this.lastProcessCpuTime = cpuTime;
        }
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value = 0;
            }
            this.log(name, value);
            this.statsMap.put(name, value);
        }
        this.refreshStats();
    }
}

