/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.ParameterType;
import org.apache.geode.management.configuration.AutoSerializer;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class AutoSerializerConverter
extends ConfigurationConverter<AutoSerializer, DeclarableType> {
    private static final String AUTO_SERIALIZER_CLASS_NAME = "org.apache.geode.pdx.ReflectionBasedAutoSerializer";
    private static final String PATTERNS_PROPERTY_NAME = "classes";
    private static final String PORTABLE_PROPERTY_NAME = "check-portability";

    @Override
    protected AutoSerializer fromNonNullXmlObject(DeclarableType xmlObject) {
        if (!xmlObject.getClassName().equals(AUTO_SERIALIZER_CLASS_NAME)) {
            return null;
        }
        Boolean portable = null;
        List<String> patterns = null;
        for (ParameterType parameter : xmlObject.getParameters()) {
            if (PATTERNS_PROPERTY_NAME.equals(parameter.getName())) {
                if (parameter.getString() == null) continue;
                patterns = Arrays.asList(parameter.getString().split("\\s*,\\s*"));
                continue;
            }
            if (PORTABLE_PROPERTY_NAME.equals(parameter.getName())) {
                portable = Boolean.parseBoolean(parameter.getString());
                continue;
            }
            return null;
        }
        return new AutoSerializer(portable, patterns);
    }

    @Override
    protected DeclarableType fromNonNullConfigObject(AutoSerializer configObject) {
        Properties properties = new Properties();
        List patterns = configObject.getPatterns();
        if (patterns != null && !patterns.isEmpty()) {
            properties.setProperty(PATTERNS_PROPERTY_NAME, StringUtils.join((Iterable)patterns, (char)','));
        }
        if (configObject.isPortable().booleanValue()) {
            properties.setProperty(PORTABLE_PROPERTY_NAME, "true");
        }
        return new DeclarableType(AUTO_SERIALIZER_CLASS_NAME, properties);
    }
}

