/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.converters;

import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.IndexType;
import org.apache.geode.management.internal.configuration.converters.ConfigurationConverter;

public class IndexConverter
extends ConfigurationConverter<Index, RegionConfig.Index> {
    private static final String HASH = "hash";
    private static final String RANGE = "range";

    @Override
    protected Index fromNonNullXmlObject(RegionConfig.Index regionConfigIndex) {
        Index index = new Index();
        index.setName(regionConfigIndex.getName());
        index.setExpression(regionConfigIndex.getExpression());
        index.setRegionPath(regionConfigIndex.getFromClause());
        Boolean keyIndex = regionConfigIndex.isKeyIndex();
        if (keyIndex != null && keyIndex.booleanValue()) {
            index.setIndexType(IndexType.KEY);
        } else if (HASH.equalsIgnoreCase(regionConfigIndex.getType())) {
            index.setIndexType(IndexType.HASH_DEPRECATED);
        } else {
            index.setIndexType(IndexType.RANGE);
        }
        return index;
    }

    @Override
    protected RegionConfig.Index fromNonNullConfigObject(Index index) {
        RegionConfig.Index regionConfigIndex = new RegionConfig.Index();
        regionConfigIndex.setName(index.getName());
        regionConfigIndex.setFromClause(index.getRegionPath());
        regionConfigIndex.setExpression(index.getExpression());
        if (index.getIndexType() == IndexType.KEY) {
            regionConfigIndex.setKeyIndex(true);
        } else if (index.getIndexType() == IndexType.HASH_DEPRECATED) {
            regionConfigIndex.setType(HASH);
        } else {
            regionConfigIndex.setType(RANGE);
        }
        return regionConfigIndex;
    }
}

