/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import java.io.File;
import java.time.Instant;
import java.util.Map;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DeployedJar;
import org.apache.geode.internal.JarDeployer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.configuration.realizers.ReadOnlyConfigurationRealizer;
import org.apache.geode.management.runtime.DeploymentInfo;

public class DeploymentRealizer
extends ReadOnlyConfigurationRealizer<Deployment, DeploymentInfo> {
    static final String JAR_NOT_DEPLOYED = "Jar file not deployed on the server.";

    @Override
    public DeploymentInfo get(Deployment config, InternalCache cache) {
        Map<String, DeployedJar> deployedJars = this.getDeployedJars();
        DeploymentInfo info = new DeploymentInfo();
        String artifactId = JarDeployer.getArtifactId(config.getJarFileName());
        DeployedJar deployedJar = deployedJars.get(artifactId);
        if (deployedJar != null) {
            File file = deployedJar.getFile();
            info.setLastModified(this.getDateString(file.lastModified()));
            info.setJarLocation(file.getAbsolutePath());
        } else {
            info.setJarLocation(JAR_NOT_DEPLOYED);
        }
        return info;
    }

    String getDateString(long milliseconds) {
        return Instant.ofEpochMilli(milliseconds).toString();
    }

    Map<String, DeployedJar> getDeployedJars() {
        JarDeployer jarDeployer = ClassPathLoader.getLatest().getJarDeployer();
        return jarDeployer.getDeployedJars();
    }
}

