/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.internal.json.JSONToPdxMapper;
import org.apache.geode.pdx.internal.json.PdxListHelper;
import org.apache.logging.log4j.Logger;

public class PdxInstanceSortedHelper
implements JSONToPdxMapper {
    private static final Logger logger = LogService.getLogger();
    JSONToPdxMapper m_parent;
    LinkedList<JSONFieldHolder<?>> fieldList = new LinkedList();
    PdxInstance m_pdxInstance;
    String m_PdxName;
    private Set<String> identityFields;

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public PdxInstanceSortedHelper(String className, JSONToPdxMapper parent, String ... identityFields) {
        if (logger.isTraceEnabled()) {
            logger.trace("ClassName {}", (Object)className);
        }
        this.m_PdxName = className;
        this.m_parent = parent;
        this.initializeIdentityFields(identityFields);
    }

    public void initializeIdentityFields(String ... identityFields) {
        this.identityFields = new HashSet<String>();
        for (String identityField : identityFields) {
            this.identityFields.add(identityField);
        }
    }

    @Override
    public JSONToPdxMapper getParent() {
        return this.m_parent;
    }

    @Override
    public void setPdxFieldName(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPdxClassName : {}", (Object)name);
        }
        this.m_PdxName = name;
    }

    @Override
    public void addStringField(String fieldName, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<String>(fieldName, value, FieldType.STRING));
    }

    @Override
    public void addByteField(String fieldName, byte value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Byte>(fieldName, value, FieldType.BYTE));
    }

    @Override
    public void addShortField(String fieldName, short value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Short>(fieldName, value, FieldType.SHORT));
    }

    @Override
    public void addIntField(String fieldName, int value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Integer>(fieldName, value, FieldType.INT));
    }

    @Override
    public void addLongField(String fieldName, long value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Long>(fieldName, value, FieldType.LONG));
    }

    @Override
    public void addBigDecimalField(String fieldName, BigDecimal value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<BigDecimal>(fieldName, value, FieldType.OBJECT));
    }

    @Override
    public void addBigIntegerField(String fieldName, BigInteger value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<BigInteger>(fieldName, value, FieldType.OBJECT));
    }

    @Override
    public void addBooleanField(String fieldName, boolean value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Boolean>(fieldName, value, FieldType.BOOLEAN));
    }

    @Override
    public void addFloatField(String fieldName, float value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldName: {}; value: {}", (Object)fieldName, (Object)Float.valueOf(value));
        }
        this.fieldList.add(new JSONFieldHolder<Float>(fieldName, Float.valueOf(value), FieldType.FLOAT));
    }

    @Override
    public void addDoubleField(String fieldName, double value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.fieldList.add(new JSONFieldHolder<Double>(fieldName, value, FieldType.DOUBLE));
    }

    @Override
    public void addNullField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNullField fieldName: {}; value: NULL", (Object)fieldName);
        }
        this.fieldList.add(new JSONFieldHolder<Object>(fieldName, null, FieldType.OBJECT));
    }

    @Override
    public void addListField(String fieldName, PdxListHelper list) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField fieldName: {}", (Object)fieldName);
        }
        this.fieldList.add(new JSONFieldHolder<List>(fieldName, list.getList(), FieldType.OBJECT));
    }

    @Override
    public void endListField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField fieldName: {}", (Object)fieldName);
        }
    }

    @Override
    public void addObjectField(String fieldName, Object member) {
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", (Object)fieldName);
        }
        if (fieldName == null) {
            throw new IllegalStateException("addObjectField:Object should have fieldname");
        }
        this.fieldList.add(new JSONFieldHolder<Object>(fieldName, member, FieldType.OBJECT));
    }

    @Override
    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstance = this.createPdxInstance();
    }

    private PdxInstance createPdxInstance() {
        Collections.sort(this.fieldList);
        PdxInstanceFactory factory = this.createPdxInstanceFactory();
        for (JSONFieldHolder jSONFieldHolder : this.fieldList) {
            this.filldata(factory, jSONFieldHolder);
            this.addIdentityField(factory, jSONFieldHolder.fieldName);
        }
        return factory.create();
    }

    private void filldata(PdxInstanceFactory factory, JSONFieldHolder key) {
        switch (key.type) {
            case BOOLEAN: {
                factory.writeBoolean(key.fieldName, (Boolean)key.value);
                break;
            }
            case BYTE: {
                factory.writeByte(key.fieldName, (Byte)key.value);
                break;
            }
            case SHORT: {
                factory.writeShort(key.fieldName, (Short)key.value);
                break;
            }
            case INT: {
                factory.writeInt(key.fieldName, (Integer)key.value);
                break;
            }
            case LONG: {
                factory.writeLong(key.fieldName, (Long)key.value);
                break;
            }
            case FLOAT: {
                factory.writeFloat(key.fieldName, ((Float)key.value).floatValue());
                break;
            }
            case DOUBLE: {
                factory.writeDouble(key.fieldName, (Double)key.value);
                break;
            }
            case STRING: 
            case OBJECT: {
                factory.writeObject(key.fieldName, key.value);
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert json field " + key);
            }
        }
    }

    private void addIdentityField(PdxInstanceFactory factory, String fieldName) {
        if (this.identityFields.contains(fieldName)) {
            factory.markIdentityField(fieldName);
        }
    }

    private PdxInstanceFactory createPdxInstanceFactory() {
        InternalCache cache = this.getCache();
        return cache.createPdxInstanceFactory("__GEMFIRE_JSON", false);
    }

    @Override
    public PdxInstance getPdxInstance() {
        return this.m_pdxInstance;
    }

    @Override
    public String getPdxFieldName() {
        return this.m_PdxName;
    }

    static class JSONFieldHolder<T>
    implements Comparable<JSONFieldHolder> {
        private String fieldName;
        private T value;
        private FieldType type;

        public JSONFieldHolder(String fn, T v, FieldType ft) {
            this.fieldName = fn;
            this.value = v;
            this.type = ft;
        }

        @Override
        public int compareTo(JSONFieldHolder other) {
            return this.fieldName.compareTo(other.fieldName);
        }

        public String toString() {
            return "JSONFieldHolder [fieldName=" + this.fieldName + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + "]";
        }
    }
}

