/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqAttributesFactory;
import org.apache.geode.cache.query.CqListener;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.kafka.GeodeContext;
import org.apache.geode.kafka.Version;
import org.apache.geode.kafka.source.EventBufferSupplier;
import org.apache.geode.kafka.source.GeodeEvent;
import org.apache.geode.kafka.source.GeodeKafkaSourceListener;
import org.apache.geode.kafka.source.GeodeSourceConnectorConfig;
import org.apache.geode.kafka.source.SharedEventBufferSupplier;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeKafkaSourceTask
extends SourceTask {
    private static final Logger logger = LoggerFactory.getLogger(GeodeKafkaSourceTask.class);
    private static final String TASK_PREFIX = "TASK";
    private static final String DOT = ".";
    private static final Map<String, Long> OFFSET_DEFAULT = GeodeKafkaSourceTask.createOffset();
    private GeodeContext geodeContext;
    private EventBufferSupplier eventBufferSupplier;
    private Map<String, List<String>> regionToTopics;
    private Map<String, Map<String, String>> sourcePartitions;
    private int batchSize;

    private static Map<String, Long> createOffset() {
        HashMap<String, Long> offset = new HashMap<String, Long>();
        offset.put("OFFSET", 0L);
        return offset;
    }

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) {
        logger.info("Starting Apache Geode source task");
        try {
            GeodeSourceConnectorConfig geodeConnectorConfig = new GeodeSourceConnectorConfig(props);
            logger.debug("GeodeKafkaSourceTask id:" + geodeConnectorConfig.getTaskId() + " starting");
            this.geodeContext = new GeodeContext();
            ClientCache clientCache = this.geodeContext.connectClient(geodeConnectorConfig.getLocatorHostPorts(), geodeConnectorConfig.getDurableClientId(), geodeConnectorConfig.getDurableClientTimeout(), geodeConnectorConfig.getSecurityClientAuthInit(), geodeConnectorConfig.getSecurityUserName(), geodeConnectorConfig.getSecurityPassword(), geodeConnectorConfig.usesSecurity());
            if (clientCache == null) {
                throw new ConnectException("Unable to create client cache in the source task");
            }
            this.batchSize = geodeConnectorConfig.getBatchSize();
            this.eventBufferSupplier = new SharedEventBufferSupplier(geodeConnectorConfig.getQueueSize());
            this.regionToTopics = geodeConnectorConfig.getRegionToTopics();
            this.sourcePartitions = this.createSourcePartitionsMap(this.regionToTopics.keySet());
            String cqPrefix = geodeConnectorConfig.getCqPrefix();
            boolean loadEntireRegion = geodeConnectorConfig.getLoadEntireRegion();
            this.installOnGeode(geodeConnectorConfig, this.geodeContext, this.eventBufferSupplier, cqPrefix, loadEntireRegion);
            logger.info("Started Apache Geode source task");
        }
        catch (Exception e) {
            logger.error("Unable to start source task", (Throwable)e);
            if (e instanceof ConnectException) {
                throw e;
            }
            throw new ConnectException((Throwable)e);
        }
    }

    public List<SourceRecord> poll() {
        logger.trace("Polling for new data");
        ArrayList<SourceRecord> records = new ArrayList<SourceRecord>(this.batchSize);
        ArrayList events = new ArrayList(this.batchSize);
        if (((BlockingQueue)this.eventBufferSupplier.get()).drainTo(events, this.batchSize) > 0) {
            logger.debug("Geode events polled :" + events.size());
            for (GeodeEvent event : events) {
                String regionName = event.getRegionName();
                List<String> topics = this.regionToTopics.get(regionName);
                for (String topic : topics) {
                    records.add(new SourceRecord(this.sourcePartitions.get(regionName), OFFSET_DEFAULT, topic, null, event.getKey(), null, event.getValue()));
                }
            }
            return records;
        }
        return null;
    }

    public void stop() {
        logger.info("Stopping Apache Geode source task");
        this.geodeContext.close(true);
    }

    void installOnGeode(GeodeSourceConnectorConfig geodeConnectorConfig, GeodeContext geodeContext, EventBufferSupplier eventBuffer, String cqPrefix, boolean loadEntireRegion) {
        boolean isDurable = geodeConnectorConfig.isDurable();
        int taskId = geodeConnectorConfig.getTaskId();
        for (String region : geodeConnectorConfig.getCqsToRegister()) {
            this.installListenersToRegion(geodeContext, taskId, eventBuffer, region, cqPrefix, loadEntireRegion, isDurable);
        }
        if (isDurable) {
            geodeContext.getClientCache().readyForEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeodeKafkaSourceListener installListenersToRegion(GeodeContext geodeContext, int taskId, EventBufferSupplier eventBuffer, String regionName, String cqPrefix, boolean loadEntireRegion, boolean isDurable) {
        CqAttributesFactory cqAttributesFactory = new CqAttributesFactory();
        GeodeKafkaSourceListener listener = new GeodeKafkaSourceListener(eventBuffer, regionName);
        cqAttributesFactory.addCqListener((CqListener)listener);
        CqAttributes cqAttributes = cqAttributesFactory.create();
        try {
            if (loadEntireRegion) {
                CqResults events = geodeContext.newCqWithInitialResults(this.generateCqName(taskId, cqPrefix, regionName), "select * from /" + regionName, cqAttributes, isDurable);
                ((BlockingQueue)eventBuffer.get()).addAll(events.stream().map(e -> new GeodeEvent(regionName, ((Struct)e).get("key"), ((Struct)e).get("value"))).collect(Collectors.toList()));
            } else {
                CqQuery cqQuery = geodeContext.newCq(this.generateCqName(taskId, cqPrefix, regionName), "select * from /" + regionName, cqAttributes, isDurable);
                if (cqQuery == null) {
                    throw new ConnectException("Unable to executed queries on the Apache Geode server");
                }
            }
        }
        finally {
            listener.signalInitialResultsLoaded();
        }
        return listener;
    }

    Map<String, Map<String, String>> createSourcePartitionsMap(Collection<String> regionNames) {
        return regionNames.stream().map(regionName -> {
            HashMap<String, String> sourcePartition = new HashMap<String, String>();
            sourcePartition.put("regionPartition", (String)regionName);
            return sourcePartition;
        }).collect(Collectors.toMap(s -> (String)s.get("regionPartition"), s -> s));
    }

    String generateCqName(int taskId, String cqPrefix, String regionName) {
        return cqPrefix + DOT + TASK_PREFIX + taskId + DOT + regionName;
    }
}

