/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;
import org.apache.geode.internal.serialization.SanctionedSerializablesService;

public class SanctionedSerializables {
    public static Collection<SanctionedSerializablesService> loadSanctionedSerializablesServices() {
        ServiceLoader<SanctionedSerializablesService> loader = ServiceLoader.load(SanctionedSerializablesService.class);
        ArrayList<SanctionedSerializablesService> services = new ArrayList<SanctionedSerializablesService>();
        for (SanctionedSerializablesService service : loader) {
            services.add(service);
        }
        return services;
    }

    public static Collection<String> loadClassNames(URL sanctionedSerializables) throws IOException {
        if (sanctionedSerializables == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(1000);
        try (InputStream inputStream = sanctionedSerializables.openStream();
             BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                line = line.replaceAll("/", ".");
                result.add(line.substring(0, line.indexOf(44)));
            }
        }
        return result;
    }
}

