/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.management.api.ClusterManagementException;
import org.apache.geode.management.api.ClusterManagementGetResult;
import org.apache.geode.management.api.ClusterManagementListOperationsResult;
import org.apache.geode.management.api.ClusterManagementListResult;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.api.ClusterManagementOperationResult;
import org.apache.geode.management.api.ClusterManagementRealizationResult;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.ClusterManagementServiceTransport;
import org.apache.geode.management.api.CommandType;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.runtime.OperationResult;
import org.apache.geode.management.runtime.RuntimeInfo;

public class ClientClusterManagementService
implements ClusterManagementService {
    private final ClusterManagementServiceTransport transport;

    public ClientClusterManagementService(ClusterManagementServiceTransport transport) {
        this.transport = transport;
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult create(T config) {
        return this.assertSuccessful(this.transport.submitMessage(config, CommandType.CREATE, ClusterManagementRealizationResult.class));
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult delete(T config) {
        return this.assertSuccessful(this.transport.submitMessage(config, CommandType.DELETE, ClusterManagementRealizationResult.class));
    }

    @Override
    public <T extends AbstractConfiguration<?>> ClusterManagementRealizationResult update(T config) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementListResult<T, R> list(T config) {
        return this.assertSuccessful(this.transport.submitMessageForList(config, ClusterManagementListResult.class));
    }

    @Override
    public <T extends AbstractConfiguration<R>, R extends RuntimeInfo> ClusterManagementGetResult<T, R> get(T config) {
        return this.assertSuccessful(this.transport.submitMessageForGet(config, ClusterManagementGetResult.class));
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementOperationResult<V> start(A op) {
        return this.transport.submitMessageForStart(op);
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> ClusterManagementListOperationsResult<V> list(A opType) {
        return this.transport.submitMessageForListOperation(opType, ClusterManagementListOperationsResult.class);
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void close() {
        this.transport.close();
    }

    private <T extends ClusterManagementResult> T assertSuccessful(T result) {
        if (result == null) {
            ClusterManagementResult somethingVeryBadHappened = new ClusterManagementResult(ClusterManagementResult.StatusCode.ERROR, "Unable to parse server response.");
            throw new ClusterManagementException(somethingVeryBadHappened);
        }
        if (!result.isSuccessful()) {
            throw new ClusterManagementException(result);
        }
        return result;
    }
}

