/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.scanning;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

class ClasspathFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathFileVisitor.class);
    private final Path basePath;
    private final BiConsumer<Path, Path> consumer;
    private final Predicate<Path> filter;

    ClasspathFileVisitor(Path basePath, Predicate<Path> filter, BiConsumer<Path, Path> consumer) {
        this.basePath = basePath;
        this.filter = filter;
        this.consumer = consumer;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
        if (this.filter.test(file)) {
            this.consumer.accept(this.basePath, file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException ex) {
        logger.warn(ex, () -> "I/O error visiting file: " + file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
        if (ex != null) {
            logger.warn(ex, () -> "I/O error visiting directory: " + dir);
        }
        return FileVisitResult.CONTINUE;
    }
}

