/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.reporter;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Public;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class AbstractReporter
implements MetricReporter,
CharacterFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<Gauge<?>, String> gauges = new HashMap();
    protected final Map<Counter, String> counters = new HashMap<Counter, String>();
    protected final Map<Histogram, String> histograms = new HashMap<Histogram, String>();
    protected final Map<Meter, String> meters = new HashMap<Meter, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        String name = group.getMetricIdentifier(metricName, this);
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            switch (metric.getMetricType()) {
                case COUNTER: {
                    this.counters.put((Counter)metric, name);
                    break;
                }
                case GAUGE: {
                    this.gauges.put((Gauge)metric, name);
                    break;
                }
                case HISTOGRAM: {
                    this.histograms.put((Histogram)metric, name);
                    break;
                }
                case METER: {
                    this.meters.put((Meter)metric, name);
                    break;
                }
                default: {
                    this.log.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            switch (metric.getMetricType()) {
                case COUNTER: {
                    this.counters.remove(metric);
                    break;
                }
                case GAUGE: {
                    this.gauges.remove(metric);
                    break;
                }
                case HISTOGRAM: {
                    this.histograms.remove(metric);
                    break;
                }
                case METER: {
                    this.meters.remove(metric);
                    break;
                }
                default: {
                    this.log.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
    }
}

