/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.hints.HintsCatalog;
import org.apache.cassandra.hints.HintsDispatchExecutor;
import org.apache.cassandra.hints.HintsService;
import org.apache.cassandra.hints.HintsStore;
import org.apache.cassandra.hints.HintsWriteExecutor;

final class HintsDispatchTrigger
implements Runnable {
    private final HintsCatalog catalog;
    private final HintsWriteExecutor writeExecutor;
    private final HintsDispatchExecutor dispatchExecutor;
    private final AtomicBoolean isPaused;

    HintsDispatchTrigger(HintsCatalog catalog, HintsWriteExecutor writeExecutor, HintsDispatchExecutor dispatchExecutor, AtomicBoolean isPaused) {
        this.catalog = catalog;
        this.writeExecutor = writeExecutor;
        this.dispatchExecutor = dispatchExecutor;
        this.isPaused = isPaused;
    }

    @Override
    public void run() {
        if (this.isPaused.get()) {
            return;
        }
        this.catalog.stores().filter(store -> !this.isScheduled((HintsStore)store)).filter(HintsStore::isLive).filter(store -> store.isWriting() || store.hasFiles()).forEach(this::schedule);
    }

    private void schedule(HintsStore store) {
        if (store.hasFiles()) {
            this.dispatchExecutor.dispatch(store);
        }
        if (store.isWriting()) {
            this.writeExecutor.closeWriter(store);
        }
        HintsService.instance.getHintsBufferPool().clearEarliestHintsForHostId(store.hostId);
    }

    private boolean isScheduled(HintsStore store) {
        return this.dispatchExecutor.isScheduled(store);
    }
}

