/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.keys;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class Ed25519PublicKey
implements PublicKey {
    private static final byte[] ED25519_OID = new byte[]{43, 101, 112};
    private static final int KEY_BYTES_LENGTH = 32;
    private static final int ENCODED_SIZE = 44;
    private final byte[] keyBytes;

    public Ed25519PublicKey(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public Ed25519PublicKey(X509EncodedKeySpec keySpec) throws InvalidKeySpecException {
        this.keyBytes = Ed25519PublicKey.decode(keySpec.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        TypesWriter tw = new TypesWriter();
        tw.writeByte(48);
        tw.writeByte(7 + ED25519_OID.length + this.keyBytes.length);
        tw.writeByte(48);
        tw.writeByte(2 + ED25519_OID.length);
        tw.writeByte(6);
        tw.writeByte(ED25519_OID.length);
        tw.writeBytes(ED25519_OID);
        tw.writeByte(3);
        tw.writeByte(this.keyBytes.length + 1);
        tw.writeByte(0);
        tw.writeBytes(this.keyBytes);
        return tw.getBytes();
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyBytes);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ed25519PublicKey)) {
            return false;
        }
        Ed25519PublicKey other = (Ed25519PublicKey)o;
        if (this.keyBytes == null || other.keyBytes == null) {
            return false;
        }
        return Arrays.equals(this.keyBytes, other.keyBytes);
    }

    private static byte[] decode(byte[] input) throws InvalidKeySpecException {
        if (input.length != 44) {
            throw new InvalidKeySpecException("Key is not of correct size");
        }
        try {
            TypesReader tr = new TypesReader(input);
            if (tr.readByte() != 48 || tr.readByte() != 7 + ED25519_OID.length + 32 || tr.readByte() != 48 || tr.readByte() != 2 + ED25519_OID.length || tr.readByte() != 6 || tr.readByte() != ED25519_OID.length) {
                throw new InvalidKeySpecException("Key was not encoded correctly");
            }
            byte[] oid = tr.readBytes(ED25519_OID.length);
            if (!Arrays.equals(oid, ED25519_OID) || tr.readByte() != 3 || tr.readByte() != 33 || tr.readByte() != 0) {
                throw new InvalidKeySpecException("Key was not encoded correctly");
            }
            return tr.readBytes(32);
        }
        catch (IOException e) {
            throw new InvalidKeySpecException("Key was not encoded correctly");
        }
    }

    public byte[] getAbyte() {
        return this.keyBytes;
    }
}

