/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.analyticquery;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQueryData;
import org.apache.hop.pipeline.transforms.analyticquery.AnalyticQueryMeta;
import org.apache.hop.pipeline.transforms.analyticquery.QueryField;

public class AnalyticQuery
extends BaseTransform<AnalyticQueryMeta, AnalyticQueryData> {
    private static final Class<?> PKG = AnalyticQuery.class;

    public AnalyticQuery(TransformMeta transformMeta, AnalyticQueryMeta meta, AnalyticQueryData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (this.first) {
            ((AnalyticQueryData)this.data).inputRowMeta = this.getInputRowMeta();
            if (((AnalyticQueryData)this.data).inputRowMeta == null) {
                ((AnalyticQueryData)this.data).inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            }
            ((AnalyticQueryData)this.data).outputRowMeta = ((AnalyticQueryData)this.data).inputRowMeta.clone();
            ((AnalyticQueryMeta)this.meta).getFields(((AnalyticQueryData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((AnalyticQueryData)this.data).groupnrs = new int[((AnalyticQueryMeta)this.meta).getGroupFields().size()];
            for (int i = 0; i < ((AnalyticQueryMeta)this.meta).getGroupFields().size(); ++i) {
                ((AnalyticQueryData)this.data).groupnrs[i] = ((AnalyticQueryData)this.data).inputRowMeta.indexOfValue(((AnalyticQueryMeta)this.meta).getGroupFields().get(i).getFieldName());
                if (((AnalyticQueryData)this.data).groupnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"AnalyticQuery.Log.GroupFieldCouldNotFound", (String[])new String[]{((AnalyticQueryMeta)this.meta).getGroupFields().get(i).getFieldName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            int maxOffset = 0;
            for (int i = 0; i < ((AnalyticQueryMeta)this.meta).getQueryFields().size(); ++i) {
                QueryField queryField = ((AnalyticQueryMeta)this.meta).getQueryFields().get(i);
                if (queryField.getValueField() <= maxOffset) continue;
                maxOffset = queryField.getValueField();
            }
            ((AnalyticQueryData)this.data).window_size = maxOffset;
            ((AnalyticQueryData)this.data).queue_size = maxOffset * 2 + 1;
            this.first = false;
        }
        if (r == null) {
            this.clearQueue();
            this.setOutputDone();
            return false;
        }
        if (!this.sameGroup(((AnalyticQueryData)this.data).previous, r)) {
            this.clearQueue();
            this.resetGroup();
        }
        ((AnalyticQueryData)this.data).data.add(r);
        while (((AnalyticQueryData)this.data).data.size() > ((AnalyticQueryData)this.data).queue_size) {
            ((AnalyticQueryData)this.data).data.poll();
        }
        ((AnalyticQueryData)this.data).previous = (Object[])r.clone();
        this.processQueue();
        if (this.isBasic() && this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"LineNr", (Object[])new Object[]{this.getLinesRead()}));
        }
        return true;
    }

    public void processQueue() throws HopTransformException {
        if (((AnalyticQueryData)this.data).data.size() == ((AnalyticQueryData)this.data).queue_size) {
            if (((AnalyticQueryData)this.data).queue_cursor <= ((AnalyticQueryData)this.data).window_size) {
                while (((AnalyticQueryData)this.data).queue_cursor <= ((AnalyticQueryData)this.data).window_size) {
                    this.processQueueObjectAt(((AnalyticQueryData)this.data).queue_cursor + 1);
                    ++((AnalyticQueryData)this.data).queue_cursor;
                }
            } else {
                this.processQueueObjectAt(((AnalyticQueryData)this.data).window_size + 1);
            }
        }
    }

    public void clearQueue() throws HopTransformException {
        if (((AnalyticQueryData)this.data).data == null) {
            return;
        }
        int numberOfRows = ((AnalyticQueryData)this.data).data.size();
        for (int i = ((AnalyticQueryData)this.data).queue_cursor; i < numberOfRows; ++i) {
            this.processQueueObjectAt(i + 1);
        }
    }

    public void processQueueObjectAt(int i) throws HopTransformException {
        int index = i - 1;
        Object[] rows = ((AnalyticQueryData)this.data).data.toArray();
        Object[] fields = new Object[((AnalyticQueryMeta)this.meta).getQueryFields().size()];
        for (int j = 0; j < ((AnalyticQueryMeta)this.meta).getQueryFields().size(); ++j) {
            QueryField queryField = ((AnalyticQueryMeta)this.meta).getQueryFields().get(j);
            int fieldIndex = ((AnalyticQueryData)this.data).inputRowMeta.indexOfValue(queryField.getSubjectField());
            int rowIndex = 0;
            switch (queryField.getAggregateType()) {
                case LAG: {
                    rowIndex = index - queryField.getValueField();
                    break;
                }
                case LEAD: {
                    rowIndex = index + queryField.getValueField();
                    break;
                }
            }
            if (rowIndex < rows.length && rowIndex >= 0) {
                Object[] singleRow = (Object[])rows[rowIndex];
                if (singleRow != null && singleRow[fieldIndex] != null) {
                    fields[j] = ((Object[])rows[rowIndex])[fieldIndex];
                    continue;
                }
                fields[j] = null;
                continue;
            }
            fields[j] = null;
        }
        Object[] newRow = RowDataUtil.addRowData((Object[])((Object[])rows[index]), (int)((AnalyticQueryData)this.data).inputRowMeta.size(), (Object[])fields);
        this.putRow(((AnalyticQueryData)this.data).outputRowMeta, newRow);
    }

    public void resetGroup() {
        ((AnalyticQueryData)this.data).data = new ConcurrentLinkedQueue();
        ((AnalyticQueryData)this.data).queue_cursor = 0;
    }

    private boolean sameGroup(Object[] previous, Object[] r) throws HopValueException {
        if (r == null && previous != null || previous == null && r != null) {
            return false;
        }
        return ((AnalyticQueryData)this.data).inputRowMeta.compare(previous, r, ((AnalyticQueryData)this.data).groupnrs) == 0;
    }

    public boolean init() {
        return super.init();
    }
}

