/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.factory.list.primitive.MutableFloatListFactory;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableFloatListFactoryImpl
implements MutableFloatListFactory {
    public static final MutableFloatListFactory INSTANCE = new MutableFloatListFactoryImpl();

    public MutableFloatList empty() {
        return new FloatArrayList();
    }

    public MutableFloatList of() {
        return this.empty();
    }

    public MutableFloatList with() {
        return this.empty();
    }

    public MutableFloatList withInitialCapacity(int capacity) {
        return new FloatArrayList(capacity);
    }

    public MutableFloatList of(float ... items) {
        return this.with(items);
    }

    public MutableFloatList with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return FloatArrayList.newListWith(items);
    }

    public MutableFloatList ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public MutableFloatList withAll(FloatIterable items) {
        return FloatArrayList.newList(items);
    }

    public MutableFloatList ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    public MutableFloatList withAll(Iterable<Float> iterable) {
        return Iterate.collectFloat(iterable, Float::floatValue, FloatLists.mutable.empty());
    }
}

