/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortShortPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.map.mutable.primitive.MutableShortKeysMap;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedShortSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

public abstract class AbstractMutableShortKeySet
implements MutableShortSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !AbstractMutableShortKeySet.isEmptyKey(key) && !AbstractMutableShortKeySet.isRemovedKey(key);
    }

    protected abstract short getKeyAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract MutableShortKeysMap getOuter();

    protected abstract AbstractSentinelValues getSentinelValues();

    public void each(ShortProcedure procedure) {
        this.getOuter().forEachKey(procedure);
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((short)0)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((short)1)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((short)0)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((short)1)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept((short)0)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept((short)1)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(short element) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(short ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(ShortIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortSet select(ShortPredicate predicate) {
        ShortHashSet result = new ShortHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((short)0)) {
                result.add((short)0);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((short)1)) {
                result.add((short)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    public MutableShortSet reject(ShortPredicate predicate) {
        ShortHashSet result = new ShortHashSet();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept((short)0)) {
                result.add((short)0);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept((short)1)) {
                result.add((short)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || predicate.accept(this.getKeyAtIndex(i))) continue;
            result.add(this.getKeyAtIndex(i));
        }
        return result;
    }

    public MutableShortSet with(short element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableShortSet without(short element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableShortSet withAll(ShortIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableShortSet withoutAll(ShortIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public <V> MutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        MutableSet result = Sets.mutable.with();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result.add(function.valueOf((short)0));
            }
            if (this.getSentinelValues().containsOneKey) {
                result.add(function.valueOf((short)1));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result.add(function.valueOf(this.getKeyAtIndex(i)));
        }
        return result;
    }

    public boolean remove(short key) {
        int oldSize = this.getOuter().size();
        this.getOuter().removeKey(key);
        return oldSize != this.getOuter().size();
    }

    public boolean removeAll(ShortIterable source) {
        int oldSize = this.getOuter().size();
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            this.getOuter().removeKey(iterator.next());
        }
        return oldSize != this.getOuter().size();
    }

    public boolean removeAll(short ... source) {
        int oldSize = this.getOuter().size();
        for (short item : source) {
            this.getOuter().removeKey(item);
        }
        return oldSize != this.getOuter().size();
    }

    public void clear() {
        this.getOuter().clear();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept((short)0)) {
                return 0;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept((short)1)) {
                return 1;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || !predicate.accept(this.getKeyAtIndex(i))) continue;
            return this.getKeyAtIndex(i);
        }
        return ifNone;
    }

    public MutableShortSet asUnmodifiable() {
        return UnmodifiableShortSet.of(this);
    }

    public MutableShortSet asSynchronized() {
        return SynchronizedShortSet.of(this);
    }

    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0L;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += (long)this.getKeyAtIndex(i);
        }
        return result;
    }

    public short max() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        short max = 0;
        boolean isMaxSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                max = 0;
                isMaxSet = true;
            }
            if (this.getSentinelValues().containsOneKey) {
                max = 1;
                isMaxSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMaxSet && max >= this.getKeyAtIndex(i)) continue;
            max = this.getKeyAtIndex(i);
            isMaxSet = true;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public short min() {
        if (this.getOuter().isEmpty()) {
            throw new NoSuchElementException();
        }
        short min = 0;
        boolean isMinSet = false;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                min = 0;
                isMinSet = true;
            }
            if (this.getSentinelValues().containsOneKey && !isMinSet) {
                min = 1;
                isMinSet = true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i)) || isMinSet && this.getKeyAtIndex(i) >= min) continue;
            min = this.getKeyAtIndex(i);
            isMinSet = true;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.getOuter().isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public short[] toArray() {
        int size = this.getOuter().size();
        final short[] result = new short[size];
        this.getOuter().forEachKey(new ShortProcedure(){
            private int index;

            public void value(short each) {
                result[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    public short[] toArray(short[] result) {
        int size = this.getOuter().size();
        if (result.length < size) {
            result = new short[size];
        }
        final short[] finalBypass = result;
        this.getOuter().forEachKey(new ShortProcedure(){
            private int index;

            public void value(short each) {
                finalBypass[this.index] = each;
                ++this.index;
            }
        });
        return result;
    }

    public boolean contains(short value) {
        return this.getOuter().containsKey(value);
    }

    public boolean containsAll(short ... source) {
        for (short item : source) {
            if (this.getOuter().containsKey(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.getOuter().containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public LazyIterable<ShortShortPair> cartesianProduct(ShortSet set) {
        return ShortSets.cartesianProduct((ShortSet)this, set);
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result = function.valueOf(result, (short)0);
            }
            if (this.getSentinelValues().containsOneKey) {
                result = function.valueOf(result, (short)1);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result = function.valueOf(result, this.getKeyAtIndex(i));
        }
        return result;
    }

    public ImmutableShortSet toImmutable() {
        return ShortSets.immutable.withAll((ShortIterable)this);
    }

    public int size() {
        return this.getOuter().size();
    }

    public boolean isEmpty() {
        return this.getOuter().isEmpty();
    }

    public boolean notEmpty() {
        return this.getOuter().notEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortSet)) {
            return false;
        }
        ShortSet other = (ShortSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        int result = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += 0;
            }
            if (this.getSentinelValues().containsOneKey) {
                ++result;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
            result += this.getKeyAtIndex(i);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(0));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!AbstractMutableShortKeySet.isNonSentinel(this.getKeyAtIndex(i))) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getKeyAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add((Object)ShortSets.mutable.withAll((ShortIterable)this));
            } else {
                MutableShortIterator iterator = this.shortIterator();
                while (iterator.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator.hasNext(); ++i) {
                        batch.add(iterator.next());
                    }
                    result.add((Object)batch);
                }
            }
        }
        return result;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerRep(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    private static class SerRep
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private transient AbstractMutableShortKeySet original;
        private transient ShortHashSet deserialized;

        public SerRep() {
        }

        private SerRep(AbstractMutableShortKeySet original) {
            this.original = original;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original.size());
            MutableShortIterator it = this.original.shortIterator();
            while (it.hasNext()) {
                out.writeShort(it.next());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int unread;
            this.deserialized = new ShortHashSet(unread);
            for (unread = in.readInt(); unread > 0; --unread) {
                this.deserialized.add(in.readShort());
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.deserialized;
        }
    }
}

