/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.JobResultEntry;
import org.apache.flink.runtime.jobmaster.JobResult;

@Internal
public interface JobResultStore {
    public CompletableFuture<Void> createDirtyResultAsync(JobResultEntry var1);

    public CompletableFuture<Void> markResultAsCleanAsync(JobID var1);

    default public CompletableFuture<Boolean> hasJobResultEntryAsync(JobID jobId) {
        return this.hasDirtyJobResultEntryAsync(jobId).thenCombine(this.hasCleanJobResultEntryAsync(jobId), (result1, result2) -> result1 != false || result2 != false);
    }

    public CompletableFuture<Boolean> hasDirtyJobResultEntryAsync(JobID var1);

    public CompletableFuture<Boolean> hasCleanJobResultEntryAsync(JobID var1);

    public Set<JobResult> getDirtyResults() throws IOException;
}

