/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jce;

import java.util.Enumeration;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.x9.X9ECParameters;
import org.python.bouncycastle.crypto.ec.CustomNamedCurves;
import org.python.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String string2) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        try {
            aSN1ObjectIdentifier = ECNamedCurveTable.possibleOID(string2) ? new ASN1ObjectIdentifier(string2) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            aSN1ObjectIdentifier = null;
        }
        X9ECParameters x9ECParameters = aSN1ObjectIdentifier != null ? CustomNamedCurves.getByOID(aSN1ObjectIdentifier) : CustomNamedCurves.getByName(string2);
        if (x9ECParameters == null) {
            x9ECParameters = aSN1ObjectIdentifier != null ? org.python.bouncycastle.asn1.x9.ECNamedCurveTable.getByOID(aSN1ObjectIdentifier) : org.python.bouncycastle.asn1.x9.ECNamedCurveTable.getByName(string2);
        }
        if (x9ECParameters == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(string2, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public static Enumeration getNames() {
        return org.python.bouncycastle.asn1.x9.ECNamedCurveTable.getNames();
    }

    private static boolean possibleOID(String string2) {
        if (string2.length() < 3 || string2.charAt(1) != '.') {
            return false;
        }
        char c = string2.charAt(0);
        return c >= '0' && c <= '2';
    }
}

