/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class CreateAuthorizedViewRequest {
    private final String tableId;
    private final CreateAuthorizedViewRequest.Builder requestBuilder = com.google.bigtable.admin.v2.CreateAuthorizedViewRequest.newBuilder();

    public static CreateAuthorizedViewRequest of(@Nonnull String tableId, @Nonnull String authorizedViewId) {
        return new CreateAuthorizedViewRequest(tableId, authorizedViewId);
    }

    private CreateAuthorizedViewRequest(@Nonnull String tableId, @Nonnull String authorizedViewId) {
        Preconditions.checkNotNull((Object)tableId, (Object)"tableId must be set");
        Preconditions.checkNotNull((Object)authorizedViewId, (Object)"authorizedViewId must be set");
        this.tableId = tableId;
        this.requestBuilder.setAuthorizedViewId(authorizedViewId);
    }

    public CreateAuthorizedViewRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getAuthorizedViewBuilder().setDeletionProtection(deletionProtection);
        return this;
    }

    public CreateAuthorizedViewRequest setAuthorizedViewType(@Nonnull AuthorizedView.AuthorizedViewType authorizedViewType) {
        Preconditions.checkNotNull((Object)authorizedViewType, (Object)"authorizedViewType must be set");
        if (!(authorizedViewType instanceof SubsetView)) {
            throw new IllegalArgumentException("Unknown authorizedViewType: " + authorizedViewType);
        }
        this.requestBuilder.getAuthorizedViewBuilder().setSubsetView(((SubsetView)authorizedViewType).toProto());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAuthorizedViewRequest that = (CreateAuthorizedViewRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build()) && Objects.equal((Object)this.tableId, (Object)that.tableId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build(), this.tableId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateAuthorizedViewRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        return this.requestBuilder.setParent(NameUtil.formatTableName(projectId, instanceId, this.tableId)).build();
    }
}

