/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class SubsetView
implements AuthorizedView.AuthorizedViewType {
    private final AuthorizedView.SubsetView.Builder builder;

    @InternalApi
    public static SubsetView fromProto(@Nonnull AuthorizedView.SubsetView proto) {
        return new SubsetView(proto);
    }

    public static SubsetView create() {
        return new SubsetView();
    }

    private SubsetView(@Nonnull AuthorizedView.SubsetView proto) {
        this.builder = proto.toBuilder();
    }

    private SubsetView() {
        this.builder = AuthorizedView.SubsetView.newBuilder();
    }

    public List<ByteString> getRowPrefixes() {
        return ImmutableList.copyOf((Collection)this.builder.getRowPrefixesList());
    }

    public Map<String, FamilySubsets> getFamilySubsets() {
        ImmutableMap.Builder familySubsets = ImmutableMap.builder();
        for (Map.Entry entry : this.builder.getFamilySubsetsMap().entrySet()) {
            familySubsets.put((Object)((String)entry.getKey()), (Object)FamilySubsets.fromProto((AuthorizedView.FamilySubsets)entry.getValue()));
        }
        return familySubsets.build();
    }

    public SubsetView addRowPrefix(ByteString rowPrefix) {
        this.builder.addRowPrefixes(rowPrefix);
        return this;
    }

    public SubsetView addRowPrefix(String rowPrefix) {
        this.builder.addRowPrefixes(ByteString.copyFromUtf8((String)rowPrefix));
        return this;
    }

    public SubsetView setFamilySubsets(String familyId, FamilySubsets familySubsets) {
        this.builder.putFamilySubsets(familyId, familySubsets.toProto());
        return this;
    }

    @InternalApi
    public AuthorizedView.SubsetView toProto() {
        return this.builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubsetView that = (SubsetView)o;
        return Objects.equal((Object)this.builder.build(), (Object)that.builder.build());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.builder.build()});
    }
}

