/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import org.apache.hop.core.Const;
import org.apache.hop.core.IDescription;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EnterTextDialog
extends Dialog {
    private static final Class<?> PKG = EnterTextDialog.class;
    private final String title;
    private final String message;
    private Label wlDesc;
    private Text wDesc;
    private Button wOk;
    private final Shell parent;
    private Shell shell;
    private final PropsUi props;
    private String text;
    private boolean fixed;
    private boolean readonly;
    private boolean modal;
    private boolean singleLine;
    private String origText;

    public EnterTextDialog(Shell parent, String title, String message, String text, boolean fixed) {
        this(parent, title, message, text);
        this.fixed = fixed;
    }

    public EnterTextDialog(Shell parent, String title, String message, String text) {
        super(parent, 0);
        this.parent = parent;
        this.props = PropsUi.getInstance();
        this.title = title;
        this.message = message;
        this.text = text;
        this.fixed = false;
        this.readonly = false;
        this.singleLine = false;
    }

    public void setReadOnly() {
        this.readonly = true;
    }

    public void setModal() {
        this.modal = true;
    }

    public void setSingleLine() {
        this.singleLine = true;
    }

    public String open() {
        this.modal |= Const.isLinux();
        this.shell = new Shell(this.parent, 0xCF0 | (this.modal ? 0x10010000 : 0));
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = PropsUi.getMargin();
        if (!this.readonly) {
            this.wOk = new Button((Composite)this.shell, 8);
            this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            this.wOk.addListener(13, e -> this.ok());
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, wCancel}, margin, null);
        } else {
            this.wOk = new Button((Composite)this.shell, 8);
            this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
            this.wOk.addListener(13, e -> this.ok());
            BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk}, margin, null);
        }
        this.wlDesc = new Label((Composite)this.shell, 0);
        this.wlDesc.setText(this.message);
        PropsUi.setLook((Widget)this.wlDesc);
        FormData fdlDesc = new FormData();
        fdlDesc.left = new FormAttachment(0, 0);
        fdlDesc.top = new FormAttachment(0, margin);
        this.wlDesc.setLayoutData((Object)fdlDesc);
        this.wDesc = this.singleLine ? new Text((Composite)this.shell, 18436) : new Text((Composite)this.shell, 19202);
        this.wDesc.setText("");
        if (this.fixed) {
            PropsUi.setLook((Widget)this.wDesc, 1);
        } else {
            PropsUi.setLook((Widget)this.wDesc);
        }
        FormData fdDesc = new FormData();
        fdDesc.left = new FormAttachment(0, 0);
        fdDesc.top = new FormAttachment((Control)this.wlDesc, margin);
        fdDesc.right = new FormAttachment(100, 0);
        fdDesc.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wDesc.setLayoutData((Object)fdDesc);
        this.wDesc.setEditable(!this.readonly);
        this.wDesc.addListener(14, e -> this.ok());
        this.wDesc.addListener(24, e -> {
            Text source = (Text)e.widget;
            this.text = source.getText();
        });
        this.enrich(this);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterTextDialog.this.checkCancel(e);
            }
        });
        this.origText = this.text;
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.text;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.text != null) {
            this.wDesc.setText(this.text);
        }
        if (this.readonly) {
            this.wOk.setFocus();
        } else {
            this.wDesc.setFocus();
        }
    }

    public void checkCancel(ShellEvent e) {
        String newText = this.wDesc.getText();
        if (!newText.equals(this.origText)) {
            int save = HopGuiWorkflowGraph.showChangedWarning(this.shell, this.title);
            if (save == 256) {
                e.doit = false;
            } else if (save == 64) {
                this.ok();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    private void cancel() {
        this.text = null;
        this.dispose();
    }

    private void ok() {
        this.text = this.wDesc.getText();
        this.dispose();
    }

    public static final void editDescription(Shell shell, IDescription iDescription, String shellText, String message) {
        EnterTextDialog textDialog = new EnterTextDialog(shell, shellText, message, iDescription.getDescription());
        String description = textDialog.open();
        if (description != null) {
            iDescription.setDescription(description);
        }
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public void enrich(EnterTextDialog enterTextDialog) {
    }

    public Label getWlDesc() {
        return this.wlDesc;
    }

    public Text getwDesc() {
        return this.wDesc;
    }

    public Shell getShell() {
        return this.shell;
    }

    public String getText() {
        return this.text;
    }

    public void setWOkListener(Listener listener) {
        this.wOk.addListener(13, listener);
    }
}

