/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mailvalidator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.validator.GenericValidator;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.actions.mailvalidator.ActionMailValidator;
import org.apache.hop.workflow.actions.mailvalidator.MailValidationResult;

public class MailValidation {
    private static final Class<?> PKG = ActionMailValidator.class;

    public static boolean isRegExValid(String emailAdress) {
        return GenericValidator.isEmail((String)emailAdress);
    }

    public static int mailServersCount(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if (attr == null) {
            return 0;
        }
        return attr.size();
    }

    private static String className() {
        return BaseMessages.getString(PKG, (String)"MailValidator.ClassName", (String[])new String[0]);
    }

    private static int hear(BufferedReader in) throws IOException {
        String line = null;
        int res = 0;
        while ((line = in.readLine()) != null) {
            String pfx = line.substring(0, 3);
            try {
                res = Integer.parseInt(pfx);
            }
            catch (Exception ex) {
                res = -1;
            }
            if (line.charAt(3) == '-') continue;
            break;
        }
        return res;
    }

    private static void say(BufferedWriter wr, String text) throws IOException {
        wr.write(text + "\r\n");
        wr.flush();
    }

    private static ArrayList<String> getMX(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if ((attr == null || attr.size() == 0) && (attr = (attrs = ictx.getAttributes(hostName, new String[]{"A"})).get("A")) == null) {
            throw new NamingException(BaseMessages.getString(PKG, (String)"MailValidator.NoMatchName", (String[])new String[]{hostName}));
        }
        ArrayList<String> res = new ArrayList<String>();
        NamingEnumeration<?> en = attr.getAll();
        while (en.hasMore()) {
            String x = (String)en.next();
            String[] f = x.split(" ");
            if (f[1].endsWith(".")) {
                f[1] = f[1].substring(0, f[1].length() - 1);
            }
            res.add(f[1]);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MailValidationResult isAddressValid(ILogChannel log, String address, String senderAddress, String defaultSMTPServer, int timeout, boolean deepCheck) {
        ArrayList<Object> mxList;
        String domain;
        MailValidationResult result;
        block56: {
            result = new MailValidationResult();
            if (!MailValidation.isRegExValid(address)) {
                result.setErrorMessage(BaseMessages.getString(PKG, (String)"MailValidator.MalformedAddress", (String[])new String[]{address}));
                return result;
            }
            int pos = address.indexOf(64);
            if (pos == -1) {
                return result;
            }
            if (!deepCheck) {
                result.setValide(true);
                return result;
            }
            domain = address.substring(++pos);
            mxList = new ArrayList<String>();
            if (Utils.isEmpty((CharSequence)defaultSMTPServer)) {
                try {
                    mxList = MailValidation.getMX(domain);
                    if (mxList == null || mxList.isEmpty()) {
                        result.setErrorMessage(BaseMessages.getString(PKG, (String)"MailValidator.NoMachinesInDomain", (String[])new String[]{domain}));
                        return result;
                    }
                    break block56;
                }
                catch (Exception ex) {
                    result.setErrorMessage(BaseMessages.getString(PKG, (String)"MailValidator.ErrorGettingMachinesInDomain", (String[])new String[]{ex.getMessage()}));
                    return result;
                }
            }
            mxList.add(defaultSMTPServer);
        }
        if (log.isDebug()) {
            log.logDebug(BaseMessages.getString(PKG, (String)"MailValidator.ExchangersFound", (String[])new String[]{"" + mxList.size()}));
        }
        for (int mx = 0; mx < mxList.size(); ++mx) {
            Socket skt;
            BufferedWriter wtr;
            BufferedReader rdr;
            boolean valid;
            block57: {
                valid = false;
                rdr = null;
                wtr = null;
                skt = null;
                String exhanger2333333332 = (String)mxList.get(mx);
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.TryingExchanger", (String[])new String[]{exhanger2333333332})});
                }
                skt = new Socket(exhanger2333333332, 25);
                if (timeout > 0) {
                    skt.setSoTimeout(timeout);
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.ConnectingTo", (String[])new String[]{exhanger2333333332, "25", "" + skt.isConnected()})});
                }
                rdr = new BufferedReader(new InputStreamReader(skt.getInputStream()));
                wtr = new BufferedWriter(new OutputStreamWriter(skt.getOutputStream()));
                int res = MailValidation.hear(rdr);
                if (res != 220) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MailValidator.InvalidHeader", (String[])new String[0]));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.SayHello", (String[])new String[]{domain})});
                }
                MailValidation.say(wtr, "EHLO " + domain);
                res = MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception("Not ESMTP");
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.ServerReplied", (String[])new String[]{"" + res})});
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.CheckSender", (String[])new String[]{senderAddress})});
                }
                MailValidation.say(wtr, "MAIL FROM: <" + senderAddress + ">");
                res = MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MailValidator.SenderRejected", (String[])new String[0]));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.SenderAccepted", (String[])new String[]{"" + res})});
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.CheckReceiver", (String[])new String[]{address})});
                }
                MailValidation.say(wtr, "RCPT TO: <" + address + ">");
                res = MailValidation.hear(rdr);
                MailValidation.say(wtr, "RSET");
                MailValidation.hear(rdr);
                MailValidation.say(wtr, "QUIT");
                MailValidation.hear(rdr);
                if (res != 250) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MailValidator.AddressNotValid", (String[])new String[]{address}));
                }
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{BaseMessages.getString(PKG, (String)"MailValidator.ReceiverAccepted", (String[])new String[]{address, "" + res})});
                }
                valid = true;
                if (rdr == null) break block57;
                try {
                    rdr.close();
                }
                catch (Exception exhanger2333333332) {
                    // empty catch block
                }
            }
            if (wtr != null) {
                try {
                    wtr.close();
                }
                catch (Exception exhanger2333333332) {
                    // empty catch block
                }
            }
            if (skt != null) {
                try {
                    skt.close();
                }
                catch (Exception exhanger2333333332) {
                    // empty catch block
                }
            }
            if (!valid) continue;
            result.setValide(true);
            result.setErrorMessage(null);
            if (log.isDebug()) {
                log.logDebug(MailValidation.className(), new Object[]{"============================================="});
            }
            return result;
            catch (Exception ex) {
                block58: {
                    try {
                        result.setValide(false);
                        result.setErrorMessage(ex.getMessage());
                        if (rdr == null) break block58;
                    }
                    catch (Throwable throwable) {
                        if (rdr != null) {
                            try {
                                rdr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (wtr != null) {
                            try {
                                wtr.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (skt != null) {
                            try {
                                skt.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (valid) {
                            result.setValide(true);
                            result.setErrorMessage(null);
                            if (log.isDebug()) {
                                log.logDebug(MailValidation.className(), new Object[]{"============================================="});
                            }
                            return result;
                        }
                        throw throwable;
                    }
                    try {
                        rdr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (wtr != null) {
                    try {
                        wtr.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (skt != null) {
                    try {
                        skt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!valid) continue;
                result.setValide(true);
                result.setErrorMessage(null);
                if (log.isDebug()) {
                    log.logDebug(MailValidation.className(), new Object[]{"============================================="});
                }
                return result;
            }
        }
        if (log.isDebug()) {
            log.logDebug(MailValidation.className(), new Object[]{"============================================="});
        }
        return result;
    }
}

