/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdCoder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MetadataCoder
extends AtomicCoder<MatchResult.Metadata> {
    private static final @UnknownKeyFor @NonNull @Initialized MetadataCoder INSTANCE = new MetadataCoder();
    private static final @UnknownKeyFor @NonNull @Initialized ResourceIdCoder RESOURCE_ID_CODER = ResourceIdCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized VarIntCoder INT_CODER = VarIntCoder.of();
    private static final @UnknownKeyFor @NonNull @Initialized VarLongCoder LONG_CODER = VarLongCoder.of();

    private MetadataCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized MetadataCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode( @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata value, @UnknownKeyFor @NonNull @Initialized OutputStream os) throws @UnknownKeyFor @NonNull @Initialized IOException {
        RESOURCE_ID_CODER.encode(value.resourceId(), os);
        INT_CODER.encode(value.isReadSeekEfficient() ? 1 : 0, os);
        LONG_CODER.encode(value.sizeBytes(), os);
    }

    @Override
    public  @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata decode(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decodeBuilder(is).build();
    }

     @UnknownKeyFor @NonNull @Initialized MatchResult.Metadata.Builder decodeBuilder(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ResourceId resourceId = RESOURCE_ID_CODER.decode(is);
        boolean isReadSeekEfficient = INT_CODER.decode(is) == 1;
        long sizeBytes = LONG_CODER.decode(is);
        return MatchResult.Metadata.builder().setResourceId(resourceId).setIsReadSeekEfficient(isReadSeekEfficient).setSizeBytes(sizeBytes);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }
}

