/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.Serializable;

public class ServerVersion
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2024 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private int vrm_;

    public ServerVersion(int vrm) {
        this.vrm_ = vrm;
    }

    public ServerVersion(String vrm) {
        if (vrm == null) {
            throw new NullPointerException("vrm");
        }
        if (vrm.length() < 6) {
            throw new ExtendedIllegalArgumentException("vrm (" + vrm + ")", 1);
        }
        vrm = vrm.toUpperCase();
        int vi = vrm.indexOf(86);
        int ri = vrm.indexOf(82);
        int mi = vrm.indexOf(77);
        if (vi != 0 || ri < 2 || mi < ri + 2 || vrm.indexOf(43) != -1) {
            throw new ExtendedIllegalArgumentException("vrm (" + vrm + ")", 2);
        }
        int version = this.getInteger(vrm.substring(1, ri));
        int release = this.getInteger(vrm.substring(ri + 1, mi));
        int modification = this.getInteger(vrm.substring(mi + 1));
        if (version < 0 || release < 0 || modification < 0) {
            throw new ExtendedIllegalArgumentException("vrm (" + vrm + ")", 2);
        }
        this.vrm_ = (version << 16) + (release << 8) + modification;
    }

    public int getVersion() {
        return this.vrm_ >> 16 & 0xFFFF;
    }

    public int getRelease() {
        return this.vrm_ >> 8 & 0xFF;
    }

    public int getModificationLevel() {
        return this.vrm_ & 0xFF;
    }

    public int getVersionReleaseModification() {
        return this.vrm_;
    }

    public void setVersionReleaseModification(int vrm) {
        this.vrm_ = vrm;
    }

    private int getInteger(String n) {
        try {
            return n == null || n.isEmpty() ? -1 : Integer.parseInt(n);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public String toString() {
        return String.format("V%dR%dM%d", this.getVersion(), this.getRelease(), this.getModificationLevel());
    }
}

