/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mapping.MappingIODefinition;
import org.apache.hop.pipeline.transforms.mapping.MappingParameters;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;
import org.apache.hop.pipeline.transforms.mapping.MappingVariableMapping;
import org.apache.hop.pipeline.transforms.mapping.SimpleMappingMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SimpleMappingDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = SimpleMappingMeta.class;
    private final SimpleMappingMeta mappingMeta;
    private TextVar wPath;
    private ComboVar wRunConfig;
    private CTabFolder wTabFolder;
    private PipelineMeta mappingPipelineMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private final MappingParameters mappingParameters;
    private final MappingIODefinition inputMapping;
    private final MappingIODefinition outputMapping;
    private final List<ApplyChanges> changeList;

    public SimpleMappingDialog(Shell parent, IVariables variables, SimpleMappingMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.mappingMeta = transformMeta;
        this.transModified = false;
        this.mappingParameters = this.mappingMeta.getMappingParameters().clone();
        this.inputMapping = this.mappingMeta.getInputMapping().clone();
        this.outputMapping = this.mappingMeta.getOutputMapping().clone();
        this.changeList = new ArrayList<ApplyChanges>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.mappingMeta);
        this.lsMod = e -> this.mappingMeta.setChanged();
        this.changed = this.mappingMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Shell.Title", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        SimpleMappingDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wicon);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment((Control)wicon, 0, 0x1000000);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment((Control)wicon, -margin);
        this.fdTransformName.left = new FormAttachment((Control)this.wlTransformName, margin);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)wicon, 0);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label wlPath = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlPath);
        wlPath.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Pipeline.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(middle, -margin);
        wlPath.setLayoutData((Object)fdlTransformation);
        Button wbBrowse = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBrowse);
        wbBrowse.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)wlPath, 0, 0x1000000);
        wbBrowse.setLayoutData((Object)fdBrowse);
        wbBrowse.addListener(13, e -> this.selectFilePipeline());
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment((Control)wlPath, margin);
        fdTransformation.top = new FormAttachment((Control)wlPath, 0, 0x1000000);
        fdTransformation.right = new FormAttachment((Control)wbBrowse, -margin);
        this.wPath.setLayoutData((Object)fdTransformation);
        Label wlRunConfig = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)wlRunConfig);
        wlRunConfig.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.RunConfig.Label", (String[])new String[0]));
        FormData fdlRunConfig = new FormData();
        fdlRunConfig.left = new FormAttachment(0, 0);
        fdlRunConfig.top = new FormAttachment((Control)this.wPath, margin);
        fdlRunConfig.right = new FormAttachment(middle, -margin);
        wlRunConfig.setLayoutData((Object)fdlRunConfig);
        this.wRunConfig = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wRunConfig);
        FormData fdRunConfig = new FormData();
        fdRunConfig.left = new FormAttachment((Control)wlRunConfig, margin);
        fdRunConfig.top = new FormAttachment((Control)wlRunConfig, 0, 0x1000000);
        fdRunConfig.right = new FormAttachment((Control)wbBrowse, -margin);
        this.wRunConfig.setLayoutData((Object)fdRunConfig);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.wTabFolder.setUnselectedCloseVisible(true);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfig, 2 * margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.mappingMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"MAP.svg", (int)32, (int)32);
    }

    private void selectFilePipeline() {
        try {
            HopPipelineFileType fileType = new HopPipelineFileType();
            String filename = BaseDialog.presentFileDialog((boolean)false, (Shell)this.shell, (String[])fileType.getFilterExtensions(), (String[])fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadPipelineFile(filename);
                this.wPath.setText(filename);
            }
        }
        catch (HopException ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), (Exception)((Object)ex));
        }
    }

    private void loadPipelineFile(String fname) throws HopException {
        this.mappingPipelineMeta = new PipelineMeta(this.variables.resolve(fname), this.metadataProvider, this.variables);
        this.mappingPipelineMeta.clearChanged();
    }

    void loadPipeline() throws HopException {
        Object filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        if (!((String)filename).endsWith(".hpl")) {
            filename = (String)filename + ".hpl";
            this.wPath.setText((String)filename);
        }
        this.loadPipelineFile((String)filename);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.mappingMeta.getFilename(), (String)""));
        this.addParametersTab(this.mappingParameters);
        this.wTabFolder.setSelection(0);
        this.addInputMappingDefinitionTab(this.inputMapping, 0);
        this.addOutputMappingDefinitionTab(this.outputMapping, 1);
        Pattern p = Pattern.compile("^[/\\w]*(\\$\\{\\w+})[/.\\w]*");
        Matcher m = p.matcher(Const.NVL((String)this.mappingMeta.getFilename(), (String)""));
        if (!m.lookingAt()) {
            try {
                this.loadPipeline();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            List runConfigs = this.metadataProvider.getSerializer(PipelineRunConfiguration.class).loadAll();
            for (PipelineRunConfiguration runConfig : runConfigs) {
                if (!(runConfig.getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration)) continue;
                this.wRunConfig.add(runConfig.getName());
            }
            this.wRunConfig.setText(Const.NVL((String)this.mappingMeta.getRunConfigurationName(), (String)""));
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error loading pipeline run configurations", (Throwable)e);
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void addOutputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.TargetField", (String[])new String[0]), false);
    }

    private void addInputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.TargetField", (String[])new String[0]), true);
    }

    private void addParametersTab(MappingParameters parameters) {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wInheritAll = new Button(wParametersComposite, 32);
        wInheritAll.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.InheritAll", (String[])new String[0]));
        PropsUi.setLook((Widget)wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment(100, -30);
        wInheritAll.setLayoutData((Object)fdInheritAll);
        wInheritAll.setSelection(parameters.isInheritingAllVariables());
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.ValueOrField", (String[])new String[0]), 1, false, false)};
        colinfo[1].setUsingVariables(true);
        TableView wMappingParameters = new TableView(this.variables, wParametersComposite, 67588, colinfo, parameters.getVariableMappings().size(), false, this.lsMod, this.props, false);
        PropsUi.setLook((Widget)wMappingParameters);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment(100, 0);
        fdMappings.top = new FormAttachment(0, 0);
        fdMappings.bottom = new FormAttachment((Control)wInheritAll, -10);
        wMappingParameters.setLayoutData((Object)fdMappings);
        wMappingParameters.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        for (int i = 0; i < parameters.getVariableMappings().size(); ++i) {
            MappingVariableMapping mapping = parameters.getVariableMappings().get(i);
            TableItem tableItem = wMappingParameters.table.getItem(i);
            tableItem.setText(1, mapping.getName());
            if (Utils.isEmpty((CharSequence)mapping.getValue())) continue;
            tableItem.setText(2, mapping.getValue());
        }
        wMappingParameters.setRowNums();
        wMappingParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
        this.changeList.add(new MappingParametersTab(wMappingParameters, wInheritAll, parameters));
    }

    public static String[] getMappingTransforms(PipelineMeta mappingPipelineMeta, boolean mappingInput) {
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : mappingPipelineMeta.getTransforms()) {
            if (mappingInput && transformMeta.getTransformPluginId().equals("MappingInput")) {
                transforms.add(transformMeta);
            }
            if (mappingInput || !transformMeta.getTransformPluginId().equals("MappingOutput")) continue;
            transforms.add(transformMeta);
        }
        String[] transformNames = new String[transforms.size()];
        for (int i = 0; i < transformNames.length; ++i) {
            transformNames[i] = ((TransformMeta)transforms.get(i)).getName();
        }
        return transformNames;
    }

    public IRowMeta getFieldsFromTransform(boolean parent, boolean input) throws HopException {
        if (input) {
            if (parent) {
                return this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            }
            if (this.mappingPipelineMeta == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
            }
            TransformMeta mappingInputTransformMeta = this.mappingPipelineMeta.findMappingInputTransform(null);
            return this.mappingPipelineMeta.getTransformFields(this.variables, mappingInputTransformMeta);
        }
        if (this.mappingPipelineMeta == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
        }
        TransformMeta mappingOutputTransformMeta = this.mappingPipelineMeta.findMappingOutputTransform(null);
        return this.mappingPipelineMeta.getTransformFields(this.variables, mappingOutputTransformMeta);
    }

    private void addMappingDefinitionTab(final MappingIODefinition definition, int index, String tabTitle, String tabTooltip, String sourceColumnLabel, String targetColumnLabel, final boolean input) {
        CTabItem wTab = index >= this.wTabFolder.getItemCount() ? new CTabItem(this.wTabFolder, 0) : new CTabItem(this.wTabFolder, 0, index);
        wTab.setFont(GuiResource.getInstance().getFontDefault());
        this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Button wbEnterMapping = new Button(wInputComposite, 8);
        PropsUi.setLook((Widget)wbEnterMapping);
        if (input) {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.EnterMapping", (String[])new String[0]));
        } else {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.GetFields", (String[])new String[0]));
        }
        FormData fdbEnterMapping = new FormData();
        fdbEnterMapping.bottom = new FormAttachment(100);
        fdbEnterMapping.right = new FormAttachment(100);
        wbEnterMapping.setLayoutData((Object)fdbEnterMapping);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(sourceColumnLabel, 1, false, false), new ColumnInfo(targetColumnLabel, 1, false, false)};
        final TableView wFieldMappings = new TableView(this.variables, wInputComposite, 67588, colinfo, 1, false, this.lsMod, this.props, false);
        PropsUi.setLook((Widget)wFieldMappings);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0);
        fdMappings.right = new FormAttachment(100);
        fdMappings.top = new FormAttachment(0);
        fdMappings.bottom = new FormAttachment((Control)wbEnterMapping, -10);
        wFieldMappings.setLayoutData((Object)fdMappings);
        wFieldMappings.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        for (MappingValueRename valueRename : definition.getValueRenames()) {
            TableItem tableItem = new TableItem(wFieldMappings.table, 0);
            tableItem.setText(1, Const.NVL((String)valueRename.getSourceValueName(), (String)""));
            tableItem.setText(2, Const.NVL((String)valueRename.getTargetValueName(), (String)""));
        }
        wFieldMappings.removeEmptyRows();
        wFieldMappings.setRowNums();
        wFieldMappings.optWidth(true);
        wbEnterMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    SimpleMappingDialog.this.loadPipeline();
                    if (input) {
                        IRowMeta sourceRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(true, input);
                        IRowMeta targetRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(false, input);
                        String[] sourceFields = sourceRowMeta.getFieldNames();
                        String[] targetFields = targetRowMeta.getFieldNames();
                        EnterMappingDialog dialog = new EnterMappingDialog(SimpleMappingDialog.this.shell, sourceFields, targetFields);
                        List mappings = dialog.open();
                        if (mappings != null) {
                            wFieldMappings.clearAll(false);
                            definition.getValueRenames().clear();
                            for (int i = 0; i < mappings.size(); ++i) {
                                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                                TableItem item = new TableItem(wFieldMappings.table, 0);
                                item.setText(1, mapping.getSourceString(sourceFields));
                                item.setText(2, mapping.getTargetString(targetFields));
                                String source = input ? item.getText(1) : item.getText(2);
                                String target = input ? item.getText(2) : item.getText(1);
                                definition.getValueRenames().add(new MappingValueRename(source, target));
                            }
                            wFieldMappings.removeEmptyRows();
                            wFieldMappings.setRowNums();
                            wFieldMappings.optWidth(true);
                        }
                    } else {
                        ITableItemInsertListener listener = (tableItem, v) -> {
                            tableItem.setText(2, tableItem.getText(1));
                            return true;
                        };
                        IRowMeta sourceRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(true, input);
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)sourceRowMeta, (TableView)wFieldMappings, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
                    }
                }
                catch (HopException e) {
                    new ErrorDialog(SimpleMappingDialog.this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.ErrorGettingMappingSourceAndTargetFields", (String[])new String[]{e.toString()}), (Exception)((Object)e));
                }
            }
        });
        if (input) {
            Button wRenameOutput = new Button(wInputComposite, 32);
            PropsUi.setLook((Widget)wRenameOutput);
            wRenameOutput.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.input.RenamingOnOutput", (String[])new String[0]));
            FormData fdRenameOutput = new FormData();
            fdRenameOutput.top = new FormAttachment((Control)wFieldMappings, 10);
            fdRenameOutput.left = new FormAttachment(0, 0);
            wRenameOutput.setLayoutData((Object)fdRenameOutput);
            wRenameOutput.setSelection(definition.isRenamingOnOutput());
            wRenameOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    definition.setRenamingOnOutput(!definition.isRenamingOnOutput());
                }
            });
        }
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wInputComposite.setLayoutData((Object)fdParametersComposite);
        wInputComposite.layout();
        wTab.setControl((Control)wInputComposite);
        MappingDefinitionTab applyChanges = new MappingDefinitionTab(definition, wFieldMappings);
        this.changeList.add(applyChanges);
        this.wTabFolder.setSelection(wTab);
    }

    private void setMappingDefinitionTabNameAndToolTip(CTabItem wTab, String tabTitle, String tabTooltip, MappingIODefinition definition, boolean input) {
        String transformName = input ? definition.getInputTransformName() : definition.getOutputTransformName();
        String description = definition.getDescription();
        if (Utils.isEmpty((CharSequence)transformName)) {
            wTab.setText(tabTitle);
        } else {
            wTab.setText(tabTitle + " : " + transformName);
        }
        Object tooltip = tabTooltip;
        if (!Utils.isEmpty((CharSequence)transformName)) {
            tooltip = (String)tooltip + Const.CR + Const.CR + transformName;
        }
        if (!Utils.isEmpty((CharSequence)description)) {
            tooltip = (String)tooltip + Const.CR + Const.CR + description;
        }
        wTab.setToolTipText((String)tooltip);
    }

    private void cancel() {
        this.transformName = null;
        this.mappingMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        if (Utils.isEmpty((CharSequence)this.wPath.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.FilenameMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.FilenameMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.isSelfReferencing()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.SelfReference.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.SelfReference.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.transformName = this.wTransformName.getText();
        String pipelinePath = this.wPath.getText();
        this.mappingMeta.setFilename(pipelinePath);
        this.mappingMeta.setRunConfigurationName(this.wRunConfig.getText());
        Pattern p = Pattern.compile("^[/\\w]*(\\$\\{\\w+})[/.\\w]*");
        Matcher m = p.matcher(this.mappingMeta.getFilename());
        if (!m.lookingAt()) {
            try {
                this.loadPipeline();
            }
            catch (HopException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), (Exception)((Object)e));
                return;
            }
        }
        this.collectInformation();
        this.mappingMeta.setMappingParameters(this.mappingParameters);
        this.mappingMeta.setInputMapping(this.inputMapping);
        this.mappingMeta.setOutputMapping(this.outputMapping);
        this.mappingMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        for (ApplyChanges applyChanges : this.changeList) {
            applyChanges.applyChanges();
        }
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wPath.getText()).equals(this.variables.resolve(this.pipelineMeta.getFilename()));
    }

    private class MappingParametersTab
    implements ApplyChanges {
        private final TableView wMappingParameters;
        private final MappingParameters parameters;
        private final Button wInheritAll;

        public MappingParametersTab(TableView wMappingParameters, Button wInheritAll, MappingParameters parameters) {
            this.wMappingParameters = wMappingParameters;
            this.wInheritAll = wInheritAll;
            this.parameters = parameters;
        }

        @Override
        public void applyChanges() {
            this.parameters.getVariableMappings().clear();
            for (TableItem item : this.wMappingParameters.getNonEmptyItems()) {
                this.parameters.getVariableMappings().add(new MappingVariableMapping(item.getText(1), item.getText(2)));
            }
            this.parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        }
    }

    private class MappingDefinitionTab
    implements ApplyChanges {
        private final MappingIODefinition definition;
        private final TableView wFieldMappings;

        public MappingDefinitionTab(MappingIODefinition definition, TableView fieldMappings) {
            this.definition = definition;
            this.wFieldMappings = fieldMappings;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wFieldMappings.nrNonEmpty();
            this.definition.getValueRenames().clear();
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                this.definition.getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
            }
        }
    }

    private static interface ApplyChanges {
        public void applyChanges();
    }
}

