/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressConverter {
    public static Inet6Address convertToIpv6(InetAddress value) {
        if (value == null || value instanceof Inet6Address) {
            return (Inet6Address)value;
        }
        byte[] bytes = new byte[16];
        bytes[10] = -1;
        bytes[11] = -1;
        System.arraycopy(value.getAddress(), 0, bytes, 12, 4);
        try {
            return Inet6Address.getByAddress(null, bytes, null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Inet4Address convertToIpv4(InetAddress value) {
        if (value == null || value instanceof Inet4Address) {
            return (Inet4Address)value;
        }
        byte[] bytes = value.getAddress();
        boolean invalid = false;
        for (int i = 0; i < 10; ++i) {
            if (bytes[i] == 0) continue;
            invalid = true;
            break;
        }
        if (!invalid) {
            boolean bl = invalid = bytes[10] != 255 || bytes[11] != 255;
        }
        if (invalid) {
            throw new IllegalArgumentException("Failed to convert IPv6 to IPv4");
        }
        byte[] addr = new byte[4];
        System.arraycopy(bytes, 12, addr, 0, 4);
        try {
            return (Inet4Address)InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

