/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.image;

import java.net.URI;
import java.util.List;
import java.util.Objects;

public class GenerateImagesResponse {
    private final List<ImageData> data;

    public GenerateImagesResponse(Builder builder) {
        this.data = builder.data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<ImageData> data() {
        return this.data;
    }

    public String toString() {
        return "GenerateImagesResponse{data=" + this.data + '}';
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || this.getClass() != another.getClass()) {
            return false;
        }
        GenerateImagesResponse anotherGenerateImagesResponse = (GenerateImagesResponse)another;
        return Objects.equals(this.data, anotherGenerateImagesResponse.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public static class Builder {
        private List<ImageData> data;

        public Builder data(List<ImageData> data) {
            this.data = data;
            return this;
        }

        public GenerateImagesResponse build() {
            return new GenerateImagesResponse(this);
        }
    }

    public static class ImageData {
        private URI url;
        private final String b64Json;
        private final String revisedPrompt;

        public ImageData(URI url, String b64Json, String revisedPrompt) {
            this.url = url;
            this.b64Json = b64Json;
            this.revisedPrompt = revisedPrompt;
        }

        public URI url() {
            return this.url;
        }

        public String b64Json() {
            return this.b64Json;
        }

        public String revisedPrompt() {
            return this.revisedPrompt;
        }

        public void url(URI url) {
            this.url = url;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            if (another == null || this.getClass() != another.getClass()) {
                return false;
            }
            ImageData anotherImageData = (ImageData)another;
            return Objects.equals(this.url, anotherImageData.url) && Objects.equals(this.b64Json, anotherImageData.b64Json) && Objects.equals(this.revisedPrompt, anotherImageData.revisedPrompt);
        }

        public int hashCode() {
            return Objects.hash(this.url, this.b64Json, this.revisedPrompt);
        }

        public String toString() {
            return "ImageData{url='" + this.url + '\'' + ", b64Json='" + this.b64Json + '\'' + ", revisedPrompt='" + this.revisedPrompt + '\'' + '}';
        }
    }
}

