/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaMeta;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;
import org.apache.hop.pipeline.transforms.formula.editor.FormulaEditor;
import org.apache.hop.ui.core.ConstUi;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FormulaDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = FormulaDialog.class;
    public static final String SYSTEM_COMBO_YES = "System.Combo.Yes";
    private TableView wFields;
    private FormulaMeta currentMeta;
    private FormulaMeta originalMeta;
    private final List<String> inputFields = new ArrayList<String>();
    private ColumnInfo[] colinf;
    private String[] fieldNames;

    public FormulaDialog(Shell parent, IVariables variables, FormulaMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.currentMeta = transformMeta;
        this.originalMeta = (FormulaMeta)((Object)transformMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.currentMeta);
        ModifyListener lsMod = e -> this.currentMeta.setChanged();
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FormulaDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FormulaDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"FormulaDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.currentMeta.getFormulas() != null ? this.currentMeta.getFormulas().size() : 1;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.NewField.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Formula.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.ValueType.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Replace.Column", (String[])new String[0]), 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.NA.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])})};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData((Object)fdFields);
        new Thread(() -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.add(row.getValueMeta(i).getName());
                    }
                    this.setComboBoxes();
                }
                catch (HopTransformException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"FormulaDialog.Log.UnableToFindInput", (String[])new String[0]));
                }
            }
        }).start();
        this.colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormulaDialog.this.fieldNames == null) {
                    return;
                }
                TableView tv = (TableView)e.widget;
                TableItem item = tv.table.getItem(e.y);
                String formula = item.getText(e.x);
                try {
                    FormulaEditor libFormulaEditor;
                    if (!FormulaDialog.this.shell.isDisposed() && (formula = (libFormulaEditor = new FormulaEditor(FormulaDialog.this.variables, FormulaDialog.this.shell, 0x10010000, Const.NVL((String)formula, (String)""), FormulaDialog.this.fieldNames)).open()) != null && !tv.isDisposed()) {
                        tv.setText(formula, e.x, e.y);
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(FormulaDialog.this.shell, "Error", "There was an unexpected error in the formula editor", ex);
                }
            }
        });
        this.wFields.addModifyListener(arg0 -> this.shell.getDisplay().asyncExec(this::setComboBoxes));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wTransformName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormulaDialog.this.ok();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FormulaDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.currentMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.transformName;
    }

    protected void setComboBoxes() {
        this.shell.getDisplay().syncExec(() -> {
            String[] fieldNames = ConstUi.sortFieldNames(this.inputFields);
            this.colinf[5].setComboValues(fieldNames);
            this.fieldNames = fieldNames;
        });
    }

    public void getData() {
        if (this.currentMeta.getFormulas() != null) {
            for (int i = 0; i < this.currentMeta.getFormulas().size(); ++i) {
                FormulaMetaFunction fn = this.currentMeta.getFormulas().get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)fn.getFieldName(), (String)""));
                item.setText(2, Const.NVL((String)fn.getFormula(), (String)""));
                item.setText(3, Const.NVL((String)ValueMetaFactory.getValueMetaName((int)fn.getValueType()), (String)""));
                if (fn.getValueLength() >= 0) {
                    item.setText(4, "" + fn.getValueLength());
                }
                if (fn.getValuePrecision() >= 0) {
                    item.setText(5, "" + fn.getValuePrecision());
                }
                item.setText(6, Const.NVL((String)fn.getReplaceField(), (String)""));
                item.setText(7, Boolean.TRUE.equals(fn.isSetNa()) ? BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.currentMeta.getFormulas().clear();
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String fieldName = item.getText(1);
            String formulaString = item.getText(2);
            int valueType = ValueMetaFactory.getIdForValueMeta((String)item.getText(3));
            int valueLength = Const.toInt((String)item.getText(4), (int)-1);
            int valuePrecision = Const.toInt((String)item.getText(5), (int)-1);
            String replaceField = item.getText(6);
            boolean setNa = BaseMessages.getString(PKG, (String)SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(item.getText(7));
            this.currentMeta.getFormulas().add(new FormulaMetaFunction(fieldName, formulaString, valueType, valueLength, valuePrecision, replaceField, setNa));
        }
        if (!((Object)((Object)this.originalMeta)).equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }
}

